/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.MethodConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedParameter;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ConstrainedMethod
extends AbstractConstrainedElement {
    private static final Log log = LoggerFactory.make();
    private final List<ConstrainedParameter> parameterMetaData;
    private final boolean hasParameterConstraints;

    public ConstrainedMethod(ConfigurationSource source, MethodConstraintLocation location, Set<MetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        this(source, location, Collections.emptyList(), returnValueConstraints, isCascading);
    }

    public ConstrainedMethod(ConfigurationSource source, MethodConstraintLocation location, List<ConstrainedParameter> parameterMetaData, Set<MetaConstraint<?>> returnValueConstraints, boolean isCascading) {
        super(source, ConstrainedElement.ConstrainedElementKind.METHOD, location, returnValueConstraints, isCascading);
        Method method = location.getMember();
        if (parameterMetaData.size() != method.getParameterTypes().length) {
            throw log.getInvalidLengthOfParameterMetaDataListException(method, method.getParameterTypes().length, parameterMetaData.size());
        }
        this.parameterMetaData = Collections.unmodifiableList(parameterMetaData);
        this.hasParameterConstraints = this.hasParameterConstraints(parameterMetaData);
    }

    private boolean hasParameterConstraints(List<ConstrainedParameter> parameterMetaData) {
        for (ConstrainedParameter oneParameter : parameterMetaData) {
            if (!oneParameter.isConstrained()) continue;
            return true;
        }
        return false;
    }

    @Override
    public MethodConstraintLocation getLocation() {
        return (MethodConstraintLocation)super.getLocation();
    }

    public List<ConstrainedParameter> getAllParameterMetaData() {
        return this.parameterMetaData;
    }

    @Override
    public boolean isConstrained() {
        return super.isConstrained() || this.hasParameterConstraints;
    }

    public boolean hasParameterConstraints() {
        return this.hasParameterConstraints;
    }

    public boolean isGetterMethod() {
        return ReflectionHelper.isGetterMethod(this.getLocation().getMember());
    }

    @Override
    public String toString() {
        return "ConstrainedMethod [location=" + this.getLocation() + ", parameterMetaData=" + this.parameterMetaData + ", hasParameterConstraints=" + this.hasParameterConstraints + "]";
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

