/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.SubsystemExtension;
import org.jboss.as.osgi.deployment.BundleActivateProcessor;
import org.jboss.as.osgi.deployment.BundleDependenciesProcessor;
import org.jboss.as.osgi.deployment.BundleDeploymentProcessor;
import org.jboss.as.osgi.deployment.BundleInstallProcessor;
import org.jboss.as.osgi.deployment.BundleResolveProcessor;
import org.jboss.as.osgi.deployment.BundleSubDeploymentMarkingProcessor;
import org.jboss.as.osgi.deployment.DeferredPhaseProcessor;
import org.jboss.as.osgi.deployment.FrameworkActivateProcessor;
import org.jboss.as.osgi.deployment.ModuleRegisterProcessor;
import org.jboss.as.osgi.deployment.OSGiBundleInfoParseProcessor;
import org.jboss.as.osgi.deployment.OSGiComponentParseProcessor;
import org.jboss.as.osgi.deployment.OSGiManifestStructureProcessor;
import org.jboss.as.osgi.deployment.OSGiXServiceParseProcessor;
import org.jboss.as.osgi.management.OSGiRuntimeResource;
import org.jboss.as.osgi.parser.OSGiRootResource;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.as.osgi.service.FrameworkBootstrapService;
import org.jboss.as.osgi.service.InitialDeploymentTracker;
import org.jboss.as.osgi.service.ModuleRegistrationTracker;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class OSGiSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final OSGiSubsystemAdd INSTANCE = new OSGiSubsystemAdd();
    private OSGiRuntimeResource resource;

    private OSGiSubsystemAdd() {
    }

    protected Resource createResource(OperationContext context) {
        this.resource = new OSGiRuntimeResource();
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)this.resource);
        return this.resource;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        OSGiRootResource.ACTIVATION.validateAndSet(operation, model);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, final ServiceVerificationHandler verificationHandler, final List<ServiceController<?>> newControllers) throws OperationFailedException {
        OSGiLogger.LOGGER.infoActivatingSubsystem();
        SubsystemState.Activation activation = SubsystemState.Activation.valueOf(OSGiRootResource.ACTIVATION.resolveModelAttribute(context, model).asString().toUpperCase(Locale.ENGLISH));
        final ServiceTarget serviceTarget = context.getServiceTarget();
        final InitialDeploymentTracker deploymentTracker = new InitialDeploymentTracker(context);
        final ModuleRegistrationTracker registrationTracker = new ModuleRegistrationTracker();
        final ArrayList<SubsystemExtension> extensions = new ArrayList<SubsystemExtension>();
        Iterator<SubsystemExtension> services = ServiceLoader.load(SubsystemExtension.class, ((Object)((Object)this)).getClass().getClassLoader()).iterator();
        while (services.hasNext()) {
            extensions.add(services.next());
        }
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                newControllers.add(FrameworkBootstrapService.addService(serviceTarget, OSGiSubsystemAdd.this.resource, deploymentTracker, extensions, verificationHandler));
                newControllers.add(registrationTracker.install(serviceTarget, verificationHandler));
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 1024, (DeploymentUnitProcessor)new OSGiManifestStructureProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.STRUCTURE, 5200, (DeploymentUnitProcessor)new BundleSubDeploymentMarkingProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 2304, (DeploymentUnitProcessor)new OSGiBundleInfoParseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 2560, (DeploymentUnitProcessor)new OSGiXServiceParseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 14080, (DeploymentUnitProcessor)new BundleDeploymentProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 8208, (DeploymentUnitProcessor)new OSGiComponentParseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.PARSE, 14336, (DeploymentUnitProcessor)new FrameworkActivateProcessor(deploymentTracker));
                processorTarget.addDeploymentProcessor("osgi", Phase.REGISTER, 256, (DeploymentUnitProcessor)new BundleInstallProcessor(deploymentTracker));
                processorTarget.addDeploymentProcessor("osgi", Phase.DEPENDENCIES, 6400, (DeploymentUnitProcessor)new BundleDependenciesProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.CONFIGURE_MODULE, 256, (DeploymentUnitProcessor)new BundleResolveProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.CONFIGURE_MODULE, 768, (DeploymentUnitProcessor)new DeferredPhaseProcessor());
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 1536, (DeploymentUnitProcessor)new ModuleRegisterProcessor(registrationTracker));
                processorTarget.addDeploymentProcessor("osgi", Phase.INSTALL, 8256, (DeploymentUnitProcessor)new BundleActivateProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        for (SubsystemExtension extension : extensions) {
            extension.performBoottime(context, operation, model, verificationHandler, newControllers);
        }
        newControllers.add(SubsystemState.addService(serviceTarget, activation));
    }
}

