/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.net.URL;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.xml.XMLParserActivator;

final class JAXPServiceProvider
extends AbstractService<Void> {
    public static final ServiceName SERVICE_NAME = OSGiConstants.SERVICE_BASE_NAME.append(new String[]{"jaxp.provider"});
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private XMLParserActivator activator;

    static ServiceController<?> addService(ServiceTarget target) {
        JAXPServiceProvider service = new JAXPServiceProvider();
        ServiceBuilder builder = target.addService(SERVICE_NAME, (Service)service);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.PASSIVE);
        return builder.install();
    }

    private JAXPServiceProvider() {
    }

    public void start(StartContext context) throws StartException {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        try {
            final ClassLoader resloader = ((Object)((Object)this)).getClass().getClassLoader();
            this.activator = new XMLParserActivator(){

                protected URL getResourceURL(Bundle parserBundle, String resname) {
                    return resloader.getResource(resname);
                }
            };
            this.activator.start(syscontext);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        if (this.activator != null) {
            try {
                this.activator.stop(syscontext);
                this.activator = null;
            }
            catch (Exception e) {
                String name = null;
                if (context != null && context.getController() != null && context.getController().getName() != null) {
                    name = context.getController().getName().getCanonicalName();
                }
                OSGiLogger.LOGGER.warnServiceStopFailed(name, e);
            }
        }
    }

    public String toString() {
        return JAXPServiceProvider.class.getSimpleName();
    }
}

