/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.URI;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.DateTimeAttribute;
import org.w3c.dom.Node;

public class DateAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#date";
    private static URI identifierURI = URI.create("http://www.w3.org/2001/XMLSchema#date");
    private static DateFormat simpleParser;
    private static DateFormat zoneParser;
    private static Calendar gmtCalendar;
    static final int NANOS_PER_MILLI = 1000000;
    static final int MILLIS_PER_SECOND = 1000;
    static final int SECONDS_PER_MINUTE = 60;
    static final int MINUTES_PER_HOUR = 60;
    static final int HOURS_PER_DAY = 24;
    static final int NANOS_PER_SECOND = 1000000000;
    static final int MILLIS_PER_MINUTE = 60000;
    static final int MILLIS_PER_HOUR = 3600000;
    static final long MILLIS_PER_DAY = 86400000L;
    public static final int TZ_UNSPECIFIED = -1000000;
    private Date value;
    private int timeZone;
    private int defaultedTimeZone;
    private String encodedValue = null;

    public DateAttribute() {
        this(new Date());
    }

    public DateAttribute(Date date) {
        super(identifierURI);
        int currOffset = DateTimeAttribute.getDefaultTZOffset(date);
        long millis = date.getTime();
        millis += (long)(currOffset * 60000);
        millis -= millis % 86400000L;
        date.setTime(millis -= (long)(currOffset * 60000));
        this.init(date, currOffset, currOffset);
    }

    public DateAttribute(Date date, int timeZone, int defaultedTimeZone) {
        super(identifierURI);
        this.init(date, timeZone, defaultedTimeZone);
    }

    private void init(Date date, int timeZone, int defaultedTimeZone) {
        this.value = (Date)date.clone();
        this.timeZone = timeZone;
        this.defaultedTimeZone = defaultedTimeZone;
    }

    public static DateAttribute getInstance(Node root) throws ParseException {
        return DateAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static DateAttribute getInstance(String value) throws ParseException {
        int defaultedTimeZone;
        int timeZone;
        Date dateValue = null;
        if (simpleParser == null) {
            DateAttribute.initParsers();
        }
        if (value.endsWith("Z")) {
            value = value.substring(0, value.length() - 1) + "+0000";
            dateValue = DateAttribute.strictParse(zoneParser, value);
            timeZone = 0;
            defaultedTimeZone = 0;
        } else {
            int len = value.length();
            if (len > 6 && value.charAt(len - 3) == ':') {
                Date gmtValue = DateAttribute.strictParse(zoneParser, value.substring(0, len - 6) + "+0000");
                value = value.substring(0, len - 3) + value.substring(len - 2, len);
                dateValue = DateAttribute.strictParse(zoneParser, value);
                timeZone = (int)(gmtValue.getTime() - dateValue.getTime());
                defaultedTimeZone = timeZone /= 60000;
            } else {
                dateValue = DateAttribute.strictParse(simpleParser, value);
                timeZone = -1000000;
                Date gmtValue = DateAttribute.strictParse(zoneParser, value + "+0000");
                defaultedTimeZone = (int)(gmtValue.getTime() - dateValue.getTime());
                defaultedTimeZone /= 60000;
            }
        }
        DateAttribute attr = new DateAttribute(dateValue, timeZone, defaultedTimeZone);
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date strictParse(DateFormat parser, String str) throws ParseException {
        Date ret;
        ParsePosition pos = new ParsePosition(0);
        DateFormat dateFormat = parser;
        synchronized (dateFormat) {
            ret = parser.parse(str, pos);
        }
        if (pos.getIndex() != str.length()) {
            throw new ParseException("", 0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initParsers() {
        if (simpleParser != null) {
            return;
        }
        URI uRI = identifierURI;
        synchronized (uRI) {
            simpleParser = new SimpleDateFormat("yyyy-MM-dd");
            simpleParser.setLenient(false);
            zoneParser = new SimpleDateFormat("yyyy-MM-ddZ");
            zoneParser.setLenient(false);
        }
    }

    @Override
    public Date getValue() {
        return (Date)this.value.clone();
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getDefaultedTimeZone() {
        return this.defaultedTimeZone;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DateAttribute)) {
            return false;
        }
        DateAttribute other = (DateAttribute)o;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DateAttribute: [\n");
        sb.append("  Date: " + this.value + " local time");
        sb.append("  TimeZone: " + this.timeZone);
        sb.append("  Defaulted TimeZone: " + this.defaultedTimeZone);
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String encode() {
        if (this.encodedValue != null) {
            return this.encodedValue;
        }
        if (this.timeZone == -1000000) {
            DateAttribute.initParsers();
            DateFormat dateFormat = simpleParser;
            synchronized (dateFormat) {
                this.encodedValue = simpleParser.format(this.value);
            }
        } else {
            this.encodedValue = this.formatDateWithTZ();
        }
        return this.encodedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDateWithTZ() {
        if (gmtCalendar == null) {
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            gmtCalendar = Calendar.getInstance(gmtTimeZone, Locale.US);
        }
        StringBuffer buf = new StringBuffer(16);
        Calendar calendar = gmtCalendar;
        synchronized (calendar) {
            gmtCalendar.setTime(this.value);
            gmtCalendar.add(12, this.timeZone);
            int year = gmtCalendar.get(1);
            buf.append(DateAttribute.zeroPadInt(year, 4));
            buf.append('-');
            int month = gmtCalendar.get(2) + 1;
            buf.append(DateAttribute.zeroPadInt(month, 2));
            buf.append('-');
            int dom = gmtCalendar.get(5);
            buf.append(DateAttribute.zeroPadInt(dom, 2));
        }
        int tzNoSign = this.timeZone;
        if (this.timeZone < 0) {
            tzNoSign = -tzNoSign;
            buf.append('-');
        } else {
            buf.append('+');
        }
        int tzHours = tzNoSign / 60;
        buf.append(DateAttribute.zeroPadInt(tzHours, 2));
        buf.append(':');
        int tzMinutes = tzNoSign % 60;
        buf.append(DateAttribute.zeroPadInt(tzMinutes, 2));
        return buf.toString();
    }

    static String zeroPadIntString(String unpadded, int minDigits) {
        int len = unpadded.length();
        char sign = unpadded.charAt(0);
        if (sign != '-' && sign != '+') {
            sign = '\u0000';
        }
        int minChars = minDigits;
        if (sign != '\u0000') {
            ++minChars;
        }
        if (len >= minChars) {
            return unpadded;
        }
        StringBuffer buf = new StringBuffer();
        if (sign != '\u0000') {
            buf.append(sign);
        }
        int zerosNeeded = minChars - len;
        while (zerosNeeded-- != 0) {
            buf.append('0');
        }
        if (sign != '\u0000') {
            buf.append(unpadded.substring(1, len));
        } else {
            buf.append(unpadded);
        }
        return buf.toString();
    }

    static String zeroPadInt(int intValue, int minDigits) {
        return DateAttribute.zeroPadIntString(Integer.toString(intValue), minDigits);
    }
}

