/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.invoker;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.context.Flag;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.SimpleCacheInvoker;

public class TransactionCacheInvoker
implements CacheInvoker {
    private final CacheInvoker invoker;

    public TransactionCacheInvoker(CacheInvoker invoker) {
        this.invoker = invoker;
    }

    public TransactionCacheInvoker() {
        this(new SimpleCacheInvoker());
    }

    @Override
    public <K, V, R> R invoke(Cache<K, V> cache, CacheInvoker.Operation<K, V, R> operation, Flag ... flags) {
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        try {
            tm.begin();
            try {
                R result = this.invoker.invoke(cache, operation, flags);
                try {
                    tm.commit();
                }
                catch (RollbackException e) {
                    throw new CacheException((Throwable)e);
                }
                catch (HeuristicMixedException e) {
                    throw new CacheException((Throwable)e);
                }
                catch (HeuristicRollbackException e) {
                    throw new CacheException((Throwable)e);
                }
                return result;
            }
            catch (RuntimeException e) {
                tm.rollback();
                throw e;
            }
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
        catch (NotSupportedException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

