/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    ACQUIRE_TIMEOUT("acquire-timeout"),
    ALIASES("aliases"),
    ASYNC_MARSHALLING("async-marshalling"),
    BATCH_SIZE("batch-size"),
    BATCHING("batching"),
    CACHE("cache"),
    CHUNK_SIZE("chunk-size"),
    CLASS("class"),
    CLUSTER("cluster"),
    CONCURRENCY_LEVEL("concurrency-level"),
    DATASOURCE("datasource"),
    DEFAULT_CACHE("default-cache"),
    DEFAULT_CACHE_CONTAINER("default-cache-container"),
    EAGER_LOCKING("eager-locking"),
    ENABLED("enabled"),
    EVICTION_EXECUTOR("eviction-executor"),
    EXECUTOR("executor"),
    FETCH_SIZE("fetch-size"),
    FETCH_STATE("fetch-state"),
    FLUSH_LOCK_TIMEOUT("flush-lock-timeout"),
    FLUSH_TIMEOUT("flush-timeout"),
    INDEXING("indexing"),
    INDEX("index"),
    INTERVAL("interval"),
    ISOLATION("isolation"),
    JNDI_NAME("jndi-name"),
    L1_LIFESPAN("l1-lifespan"),
    LIFESPAN("lifespan"),
    LISTENER_EXECUTOR("listener-executor"),
    LOCK_TIMEOUT("lock-timeout"),
    LOCKING("locking"),
    MACHINE("machine"),
    MAX_ENTRIES("max-entries"),
    MAX_IDLE("max-idle"),
    MODE("mode"),
    MODIFICATION_QUEUE_SIZE("modification-queue-size"),
    MODULE("module"),
    NAME("name"),
    NAMESPACE("xmlns"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    OWNERS("owners"),
    PASSIVATION("passivation"),
    PATH("path"),
    PREFIX("prefix"),
    PRELOAD("preload"),
    PURGE("purge"),
    QUEUE_FLUSH_INTERVAL("queue-flush-interval"),
    QUEUE_SIZE("queue-size"),
    RACK("rack"),
    RELATIVE_TO("relative-to"),
    REMOTE_TIMEOUT("remote-timeout"),
    REPLICATION_QUEUE_EXECUTOR("replication-queue-executor"),
    SEGMENTS("segments"),
    SHARED("shared"),
    SHUTDOWN_TIMEOUT("shutdown-timeout"),
    SINGLETON("singleton"),
    SITE("site"),
    SOCKET_TIMEOUT("socket-timeout"),
    STACK("stack"),
    START("start"),
    STATISTICS_ENABLED("statistics-enabled"),
    STOP_TIMEOUT("stop-timeout"),
    STRATEGY("strategy"),
    STRIPING("striping"),
    TCP_NO_DELAY("tcp-no-delay"),
    THREAD_POOL_SIZE("thread-pool-size"),
    TIMEOUT("timeout"),
    TYPE("type"),
    VIRTUAL_NODES("virtual-nodes");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

