/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.SegmentsAndVirtualNodeConverter;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheAdd;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class DistributedCacheAdd
extends SharedStateCacheAdd {
    static final DistributedCacheAdd INSTANCE = new DistributedCacheAdd();

    static ModelNode createOperation(ModelNode address, ModelNode model) throws OperationFailedException {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        INSTANCE.populate(model, operation);
        return operation;
    }

    private DistributedCacheAdd() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        String deprecatedKey = "virtual-nodes";
        if (fromModel.hasDefined("virtual-nodes") && fromModel.get("virtual-nodes").asInt() != 1) {
            InfinispanLogger.ROOT_LOGGER.virtualNodesAttributeDeprecated();
            ModelNode convertedValue = SegmentsAndVirtualNodeConverter.virtualNodesToSegments(fromModel.get("virtual-nodes"));
            fromModel.get("segments").set(convertedValue);
            fromModel.remove("virtual-nodes");
        }
        DistributedCacheResourceDefinition.OWNERS.validateAndSet(fromModel, toModel);
        DistributedCacheResourceDefinition.SEGMENTS.validateAndSet(fromModel, toModel);
        DistributedCacheResourceDefinition.L1_LIFESPAN.validateAndSet(fromModel, toModel);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, containerModel, cache, builder, dependencies);
        int owners = DistributedCacheResourceDefinition.OWNERS.resolveModelAttribute(context, cache).asInt();
        int segments = DistributedCacheResourceDefinition.SEGMENTS.resolveModelAttribute(context, cache).asInt();
        long lifespan = DistributedCacheResourceDefinition.L1_LIFESPAN.resolveModelAttribute(context, cache).asLong();
        builder.clustering().hash().numOwners(owners).numSegments(segments);
        if (lifespan > 0L) {
            builder.clustering().l1().lifespan(lifespan);
        } else {
            builder.clustering().l1().disable();
        }
    }
}

