/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheAdd;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class SharedStateCacheAdd
extends ClusteredCacheAdd {
    SharedStateCacheAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, ConfigurationBuilder builder, List<CacheAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, containerModel, cache, builder, dependencies);
        if (cache.hasDefined("state-transfer") && cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            boolean enabled = StateTransferResourceDefinition.ENABLED.resolveModelAttribute(context, stateTransfer).asBoolean();
            long timeout = StateTransferResourceDefinition.TIMEOUT.resolveModelAttribute(context, stateTransfer).asLong();
            int chunkSize = StateTransferResourceDefinition.CHUNK_SIZE.resolveModelAttribute(context, stateTransfer).asInt();
            builder.clustering().stateTransfer().fetchInMemoryState(enabled);
            builder.clustering().stateTransfer().timeout(timeout);
            builder.clustering().stateTransfer().chunkSize(chunkSize);
        }
    }
}

