/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.WorkProcessor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class AsyncWorkProcessor
implements WorkProcessor {
    private static final Log log = LoggerFactory.make();
    private volatile LuceneBackendResources resources;

    public AsyncWorkProcessor(LuceneBackendResources resources) {
        this.resources = resources;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void submit(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList.isEmpty()) {
            if (log.isTraceEnabled()) {
                StringWriter stackTraceStringWriter = new StringWriter();
                PrintWriter stackTracePrintWriter = new PrintWriter(stackTraceStringWriter);
                new Throwable().printStackTrace(stackTracePrintWriter);
                log.workListShouldNeverBeEmpty(stackTraceStringWriter.toString());
            }
            return;
        }
        LuceneBackendQueueTask luceneBackendQueueProcessor = new LuceneBackendQueueTask(workList, this.resources, monitor);
        this.resources.getAsynchIndexingExecutor().execute(luceneBackendQueueProcessor);
    }

    @Override
    public void updateResources(LuceneBackendResources resources) {
        this.resources = resources;
    }
}

