/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Date;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.facet.RangeFacet;

public class RangeFacetImpl<T>
extends AbstractFacet
implements RangeFacet<T> {
    private final FacetRange<T> range;
    private final int rangeIndex;
    private final DocumentBuilderIndexedEntity<?> documentBuilder;

    RangeFacetImpl(String facetingName, String fieldName, FacetRange<T> range, int count, int index, DocumentBuilderIndexedEntity<?> documentBuilder) {
        super(facetingName, fieldName, range.getRangeString(), count);
        this.range = range;
        this.rangeIndex = index;
        this.documentBuilder = documentBuilder;
    }

    @Override
    public Query getFacetQuery() {
        Object minOrMax = this.getNonNullMinOrMax(this.range);
        if (minOrMax instanceof Number) {
            return this.createNumericRangeQuery();
        }
        if (minOrMax instanceof String) {
            return this.createRangeQuery((String)this.range.getMin(), (String)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        if (minOrMax instanceof Date) {
            ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
            return this.createRangeQuery(this.documentBuilder.objectToString(this.getFieldName(), this.range.getMin(), conversionContext), this.documentBuilder.objectToString(this.getFieldName(), this.range.getMax(), conversionContext), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        throw new AssertionFailure("Unsupported range type");
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    @Override
    public T getMin() {
        return this.range.getMin();
    }

    @Override
    public T getMax() {
        return this.range.getMax();
    }

    @Override
    public boolean isIncludeMin() {
        return this.range.isMinIncluded();
    }

    @Override
    public boolean isIncludeMax() {
        return this.range.isMaxIncluded();
    }

    private Object getNonNullMinOrMax(FacetRange<T> range) {
        T o = range.getMin();
        if (o == null) {
            o = range.getMax();
        }
        return o;
    }

    private Query createNumericRangeQuery() {
        NumericRangeQuery query;
        Object minOrMax = this.getNonNullMinOrMax(this.range);
        if (minOrMax instanceof Double) {
            query = NumericRangeQuery.newDoubleRange((String)this.getFieldName(), (Double)((Double)this.range.getMin()), (Double)((Double)this.range.getMax()), (boolean)this.range.isMinIncluded(), (boolean)this.range.isMaxIncluded());
        } else if (minOrMax instanceof Float) {
            query = NumericRangeQuery.newFloatRange((String)this.getFieldName(), (Float)((Float)this.range.getMin()), (Float)((Float)this.range.getMax()), (boolean)this.range.isMinIncluded(), (boolean)this.range.isMaxIncluded());
        } else if (minOrMax instanceof Integer) {
            query = NumericRangeQuery.newIntRange((String)this.getFieldName(), (Integer)((Integer)this.range.getMin()), (Integer)((Integer)this.range.getMax()), (boolean)this.range.isMinIncluded(), (boolean)this.range.isMaxIncluded());
        } else if (minOrMax instanceof Long) {
            query = NumericRangeQuery.newLongRange((String)this.getFieldName(), (Long)((Long)this.range.getMin()), (Long)((Long)this.range.getMax()), (boolean)this.range.isMinIncluded(), (boolean)this.range.isMaxIncluded());
        } else {
            throw new AssertionFailure("Unsupported range type");
        }
        return query;
    }

    private Query createRangeQuery(String min, String max, boolean includeMin, boolean includeMax) {
        return new TermRangeQuery(this.getFieldName(), min, max, includeMin, includeMax);
    }
}

