/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.query.fieldcache.impl.DoubleFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.impl.FloatFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.impl.IntFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.impl.LongFieldLoadingStrategy;
import org.hibernate.search.query.fieldcache.impl.StringFieldLoadingStrategy;

public enum FieldCacheLoadingType {
    STRING{

        @Override
        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new StringFieldLoadingStrategy(fieldName);
        }
    }
    ,
    INT{

        @Override
        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new IntFieldLoadingStrategy(fieldName);
        }
    }
    ,
    LONG{

        @Override
        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new LongFieldLoadingStrategy(fieldName);
        }
    }
    ,
    DOUBLE{

        @Override
        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new DoubleFieldLoadingStrategy(fieldName);
        }
    }
    ,
    FLOAT{

        @Override
        public FieldLoadingStrategy createLoadingStrategy(String fieldName) {
            return new FloatFieldLoadingStrategy(fieldName);
        }
    };

    static Map<Class<?>, FieldCacheLoadingType> fieldCacheTypes;

    public abstract FieldLoadingStrategy createLoadingStrategy(String var1);

    public static FieldLoadingStrategy getLoadingStrategy(String fieldName, Class<?> type) {
        return fieldCacheTypes.get(type).createLoadingStrategy(fieldName);
    }

    static {
        fieldCacheTypes = new HashMap();
        fieldCacheTypes.put(String.class, STRING);
        fieldCacheTypes.put(Integer.class, INT);
        fieldCacheTypes.put(Long.class, LONG);
        fieldCacheTypes.put(Double.class, DOUBLE);
        fieldCacheTypes.put(Float.class, FLOAT);
    }
}

