/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.federation.parsers;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.parsers.AbstractParser;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.IdentityURLProviderType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.MetadataProviderType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.TrustType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;

public class SAMLConfigParser
extends AbstractParser {
    public static final String BINDING_TYPE = "BindingType";
    public static final String ERROR_PAGE = "ErrorPage";
    public static final String LOGOUT_PAGE = "LogOutPage";
    public static final String LOGOUT_URL = "LogOutUrl";
    public static final String LOGOUT_RESPONSE_LOCATION = "LogOutResponseLocation";
    public static final String IDP = "PicketLinkIDP";
    public static final String SP = "PicketLinkSP";
    public static final String IDENTITY_URL = "IdentityURL";
    public static final String SERVICE_URL = "ServiceURL";
    public static final String IDP_METADATA_FILE = "IDPMetadataFile";
    public static final String IDP_USES_POST_BINDING = "IDPUsesPostBinding";
    public static final String TRUST = "Trust";
    public static final String DOMAINS = "Domains";
    public static final String KEY_PROVIDER = "KeyProvider";
    public static final String META_PROVIDER = "MetaDataProvider";
    public static final String CLASS_NAME = "ClassName";
    public static final String CLASS = "class";
    public static final String AUTH = "Auth";
    public static final String KEY = "Key";
    public static final String VALUE = "Value";
    public static final String VALIDATING_ALIAS = "ValidatingAlias";
    public static final String ROLE_GENERATOR = "RoleGenerator";
    public static final String ENCRYPT = "Encrypt";
    public static final String HOSTED_URI = "HostedURI";
    public static final String ATTRIBUTE_MANAGER = "AttributeManager";
    public static final String CANONICALIZATION_METHOD = "CanonicalizationMethod";
    public static final String HANDLERS = "Handlers";
    public static final String HANDLERS_CHAIN_CLASS = "ChainClass";
    public static final String HANDLERS_CHAIN_LOCKING = "Locking";
    public static final String HANDLER = "Handler";
    public static final String OPTION = "Option";
    public static final String RELAY_STATE = "RelayState";
    public static final String SERVER_ENVIRONMENT = "ServerEnvironment";
    public static final String SUPPORTS_SIGNATURES = "SupportsSignatures";
    public static final String IDENTITY_PARTICIPANT_STACK = "IdentityParticipantStack";
    public static final String STRICT_POST_BINDING = "StrictPostBinding";
    public static final String SSL_CLIENT_AUTHENTICATION = "SSLClientAuthentication";
    public static final String SIGNING_ALIAS = "SigningAlias";
    public static final String PROVIDER = "Provider";
    public static final String DEFAULT_URL = "DefaultURL";
    public static final String DYNAMIC = "Dynamic";
    public static final String DOMAIN = "Domain";
    public static final String PAGE = "Page";
    public static final String TYPE = "Type";
    public static final String EXPIRATION = "Expiration";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        if (StaxParserUtil.getStartElementName((StartElement)startElement).equals(IDP)) {
            return this.parseIDPConfiguration(xmlEventReader);
        }
        if (StaxParserUtil.getStartElementName((StartElement)startElement).equals(SP)) {
            return this.parseSPConfiguration(xmlEventReader);
        }
        return this.parseHandlers(xmlEventReader);
    }

    public boolean supports(QName qname) {
        return false;
    }

    protected Handlers parseHandlers(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        QName lockingQName;
        Attribute lockingAttribute;
        Handlers handlers = new Handlers();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)HANDLERS);
        QName handlerChainClassQName = new QName("", HANDLERS_CHAIN_CLASS);
        Attribute handlerChainClass = startElement.getAttributeByName(handlerChainClassQName);
        if (handlerChainClass != null) {
            handlers.setHandlerChainClass(StaxParserUtil.getAttributeValue((Attribute)handlerChainClass));
        }
        if ((lockingAttribute = startElement.getAttributeByName(lockingQName = new QName("", HANDLERS_CHAIN_LOCKING))) != null) {
            handlers.setLocking(Boolean.valueOf(lockingAttribute.getValue()));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals(HANDLERS)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (!elementName.equals(HANDLER)) continue;
            Handler handler = this.parseHandler(xmlEventReader, startElement);
            handlers.add(handler);
        }
        return handlers;
    }

    protected IDPType parseIDPConfiguration(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        IDPType idp = new IDPType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)IDP);
        QName attributeQName = new QName("", ROLE_GENERATOR);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            idp.setRoleGenerator(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ENCRYPT))) != null) {
            idp.setEncrypt(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", HOSTED_URI))) != null) {
            idp.setHostedURI(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", CANONICALIZATION_METHOD))) != null) {
            idp.setCanonicalizationMethod(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ATTRIBUTE_MANAGER))) != null) {
            idp.setAttributeManager(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", STRICT_POST_BINDING))) != null) {
            idp.setStrictPostBinding(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SUPPORTS_SIGNATURES))) != null) {
            idp.setSupportsSignature(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", IDENTITY_PARTICIPANT_STACK))) != null) {
            idp.setIdentityParticipantStack(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SSL_CLIENT_AUTHENTICATION))) != null) {
            idp.setSSLClientAuthentication(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals(IDP)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(IDENTITY_URL)) {
                idp.setIdentityURL(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                continue;
            }
            if (elementName.equals(TRUST)) {
                TrustType trustType = new TrustType();
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((StartElement)startElement, (String)DOMAINS);
                trustType.setDomains(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)TRUST);
                idp.setTrust(trustType);
                continue;
            }
            if (elementName.equals(KEY_PROVIDER)) {
                KeyProviderType keyProviderType = this.parseKeyProvider(xmlEventReader, startElement);
                idp.setKeyProvider(keyProviderType);
                continue;
            }
            if (!elementName.equals(META_PROVIDER)) continue;
            MetadataProviderType mdProviderType = this.parseMDProvider(xmlEventReader, startElement);
            idp.setMetaDataProvider(mdProviderType);
        }
        return idp;
    }

    protected ProviderType parseSPConfiguration(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        SPType sp = new SPType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)SP);
        QName attributeQName = new QName("", CANONICALIZATION_METHOD);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            sp.setCanonicalizationMethod(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SERVER_ENVIRONMENT))) != null) {
            sp.setServerEnvironment(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", BINDING_TYPE))) != null) {
            sp.setBindingType(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", RELAY_STATE))) != null) {
            sp.setRelayState(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ERROR_PAGE))) != null) {
            sp.setErrorPage(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", LOGOUT_PAGE))) != null) {
            sp.setLogOutPage(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", LOGOUT_URL))) != null) {
            sp.setLogoutUrl(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", LOGOUT_RESPONSE_LOCATION))) != null) {
            sp.setLogoutResponseLocation(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", IDP_USES_POST_BINDING))) != null) {
            sp.setIdpUsesPostBinding(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SUPPORTS_SIGNATURES))) != null) {
            sp.setSupportsSignature(Boolean.parseBoolean(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true)));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            MetadataProviderType mdProviderType;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals(SP)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String elementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (elementName.equals(IDENTITY_URL)) {
                this.parseIdentityURLProvider(xmlEventReader, startElement, sp);
                continue;
            }
            if (elementName.equals(SERVICE_URL)) {
                sp.setServiceURL(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                continue;
            }
            if (elementName.equals(IDP_METADATA_FILE)) {
                sp.setIdpMetadataFile(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                continue;
            }
            if (elementName.equals(TRUST)) {
                TrustType trustType = new TrustType();
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((StartElement)startElement, (String)DOMAINS);
                trustType.setDomains(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)TRUST);
                sp.setTrust(trustType);
                continue;
            }
            if (elementName.equals(KEY_PROVIDER)) {
                KeyProviderType keyProviderType = this.parseKeyProvider(xmlEventReader, startElement);
                sp.setKeyProvider(keyProviderType);
                continue;
            }
            if (elementName.equals(META_PROVIDER)) {
                mdProviderType = this.parseMDProvider(xmlEventReader, startElement);
                sp.setMetaDataProvider(mdProviderType);
                continue;
            }
            if (!elementName.equals(META_PROVIDER)) continue;
            mdProviderType = this.parseMDProvider(xmlEventReader, startElement);
            sp.setMetaDataProvider(mdProviderType);
        }
        return sp;
    }

    protected KeyProviderType parseKeyProvider(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        KeyProviderType keyProviderType = new KeyProviderType();
        QName attributeQName = new QName("", CLASS_NAME);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            keyProviderType.setClassName(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            KeyValueType auth;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(KEY_PROVIDER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (startElementName.equals(AUTH)) {
                auth = new AuthPropertyType();
                this.populateKeyValueType(auth, startElement);
                keyProviderType.add((AuthPropertyType)auth);
                continue;
            }
            if (startElementName.equals(VALIDATING_ALIAS)) {
                auth = new KeyValueType();
                this.populateKeyValueType(auth, startElement);
                keyProviderType.add(auth);
                continue;
            }
            if (!startElementName.equals(SIGNING_ALIAS)) continue;
            keyProviderType.setSigningAlias(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
        }
        return keyProviderType;
    }

    protected void parseIdentityURLProvider(XMLEventReader xmlEventReader, StartElement startElement, SPType sp) throws ParsingException {
        XMLEvent xmlEvent;
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            Attribute expiration;
            Attribute type;
            Attribute page;
            Attribute domain;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(IDENTITY_URL)) continue;
                break;
            }
            if (xmlEvent.isCharacters()) {
                sp.setIdentityURL(StaxParserUtil.getElementText((XMLEventReader)xmlEventReader, (boolean)true));
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (!startElementName.equals(PROVIDER)) continue;
            IdentityURLProviderType providerType = new IdentityURLProviderType();
            sp.setIdentityURLProvider(providerType);
            Attribute defaultUrlAttribute = startElement.getAttributeByName(new QName("", DEFAULT_URL));
            if (defaultUrlAttribute != null) {
                providerType.setDefaultUrl(StaxParserUtil.getAttributeValue((Attribute)defaultUrlAttribute));
            }
            if ((domain = startElement.getAttributeByName(new QName("", DOMAIN))) != null) {
                providerType.setDomain(StaxParserUtil.getAttributeValue((Attribute)domain));
            }
            if ((page = startElement.getAttributeByName(new QName("", PAGE))) != null) {
                providerType.setPage(StaxParserUtil.getAttributeValue((Attribute)page));
            }
            if ((type = startElement.getAttributeByName(new QName("", TYPE))) != null) {
                providerType.setType(StaxParserUtil.getAttributeValue((Attribute)type));
            }
            if ((expiration = startElement.getAttributeByName(new QName("", EXPIRATION))) == null) continue;
            providerType.setExpiration(Integer.parseInt(StaxParserUtil.getAttributeValue((Attribute)expiration)));
        }
    }

    protected Handler parseHandler(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        Handler handlerType = new Handler();
        QName attributeQName = new QName("", CLASS);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            handlerType.setClazz(StaxParserUtil.getAttributeValue((Attribute)attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(HANDLER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (!startElementName.equals(OPTION)) continue;
            KeyValueType auth = new KeyValueType();
            this.populateKeyValueType(auth, startElement);
            handlerType.add(auth);
        }
        return handlerType;
    }

    protected MetadataProviderType parseMDProvider(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        XMLEvent xmlEvent = null;
        MetadataProviderType metaProviderType = new MetadataProviderType();
        QName attributeQName = new QName("", CLASS_NAME);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            metaProviderType.setClassName(StaxParserUtil.getAttributeValue((Attribute)attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals(META_PROVIDER)) continue;
                break;
            }
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            String startElementName = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (!startElementName.equals(OPTION)) continue;
            KeyValueType auth = new KeyValueType();
            this.populateKeyValueType(auth, startElement);
            metaProviderType.add(auth);
        }
        return metaProviderType;
    }

    protected void populateKeyValueType(KeyValueType kvt, StartElement startElement) {
        QName attributeQName = new QName("", KEY);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            kvt.setKey(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", OPTION))) != null) {
            kvt.setKey(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", VALUE))) != null) {
            kvt.setValue(StaxParserUtil.getAttributeValue((Attribute)attribute, (boolean)true));
        }
    }
}

