/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.io.Receiver;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.Connectors;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.handlers.security.ServletFormAuthenticationMechanism;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.SavedRequest;
import io.undertow.util.ImmediatePooledByteBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.security.audit.AuditEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.api.saml.v2.metadata.MetaDataExtractor;
import org.picketlink.identity.federation.bindings.wildfly.ServiceProviderSAMLContext;
import org.picketlink.identity.federation.bindings.wildfly.sp.SPFormAuthrenticationRequestUtil;
import org.picketlink.identity.federation.bindings.wildfly.sp.SecurityActions;
import org.picketlink.identity.federation.bindings.wildfly.sp.UndertowRedirectionHandler;
import org.picketlink.identity.federation.core.SerializablePrincipal;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.saml.workflow.ServiceProviderSAMLWorkflow;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wildfly.extension.undertow.security.AccountImpl;

public class SPFormAuthenticationMechanism
extends ServletFormAuthenticationMechanism {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String INITIAL_LOCATION_STORED = "org.picketlink.federation.saml.initial_location";
    protected transient String samlHandlerChainClass = null;
    protected final ServletContext servletContext;
    protected Map<String, Object> chainConfigOptions = new HashMap<String, Object>();
    protected SAMLConfigurationProvider configProvider;
    protected transient X509Certificate idpCertificate = null;
    protected int timerInterval = -1;
    protected Timer timer = null;
    public static final String EMPTY_PASSWORD = "EMPTY_STR";
    protected boolean enableAudit = false;
    public static final String FORM_ACCOUNT_NOTE = "picketlink.form.account";
    public static final String FORM_REQUEST_NOTE = "picketlink.REQUEST";
    protected transient SAML2HandlerChain chain = null;
    protected SPType spConfiguration = null;
    protected PicketLinkType configuration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String issuerID = null;
    protected String configFile;
    protected boolean saveRestoreRequest = true;
    protected Lock chainLock = new ReentrantLock();
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected PicketLinkAuditHelper auditHelper;
    protected TrustKeyManager keyManager;
    protected IDPSSODescriptorType idpMetadata;
    protected FormParserFactory formParserFactory;

    public SPFormAuthenticationMechanism(FormParserFactory parserFactory, String name, String loginPage, String errorPage, ServletContext servletContext, PicketLinkType configuration, PicketLinkAuditHelper auditHelper) {
        super(parserFactory, name, loginPage, errorPage);
        this.servletContext = servletContext;
        this.configuration = configuration;
        this.spConfiguration = (SPType)configuration.getIdpOrSP();
        this.auditHelper = auditHelper;
        this.formParserFactory = FormParserFactory.builder((boolean)true).build();
        this.startPicketLink();
    }

    public SPFormAuthenticationMechanism(FormParserFactory parserFactory, String name, String loginPage, String errorPage, ServletContext servletContext, SAMLConfigurationProvider configProvider, PicketLinkAuditHelper auditHelper) throws ProcessingException {
        this(parserFactory, name, loginPage, errorPage, servletContext, configProvider.getPicketLinkConfiguration(), auditHelper);
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        String samlRequest = request.getParameter("SAMLRequest");
        HttpSession session = request.getSession(true);
        Principal principal = request.getUserPrincipal();
        try {
            if (this.isAjaxRequest(request) && principal == null) {
                return new AuthenticationMechanism.ChallengeResult(false, Integer.valueOf(403));
            }
            if (!StringUtil.isNotNull((String)samlRequest) && !response.isCommitted()) {
                session.setAttribute(INITIAL_LOCATION_STORED, (Object)true);
                byte[] buffer = SPFormAuthrenticationRequestUtil.getStoredBuffer(exchange);
                int contentLength = SPFormAuthrenticationRequestUtil.getStoredBufferLength(exchange);
                if (buffer != null) {
                    this.storeInitialLocation(exchange, buffer, contentLength);
                } else {
                    this.storeInitialLocation(exchange);
                }
                return this.generalUserRequest(exchange, securityContext);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not send authn request to identity provider.", e);
        }
        if (response.isCommitted()) {
            return new AuthenticationMechanism.ChallengeResult(true);
        }
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Account savedAccount;
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl servletContext = servletRequestContext.getCurrentServletContext();
        HttpServletRequest unwrappedRequest = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSession session = unwrappedRequest.getSession(true);
        if (this.saveRestoreRequest && (savedAccount = (Account)session.getAttribute(FORM_ACCOUNT_NOTE)) != null) {
            this.register(securityContext, savedAccount);
        }
        CompletableFuture future = new CompletableFuture();
        Receiver.FullBytesCallback callback = (arg_0, arg_1) -> this.lambda$authenticate$0(exchange, servletRequestContext, response, session, (ServletContext)servletContext, future, securityContext, arg_0, arg_1);
        int maxSize = SavedRequest.getMaxBufferSizeToSave((HttpServerExchange)exchange);
        if (this.formParserFactory.createParser(exchange) == null || exchange.getRequestContentLength() > (long)maxSize) {
            callback.handle(exchange, null);
        } else {
            exchange.getRequestReceiver().receiveFullBytes(callback);
        }
        try {
            return (AuthenticationMechanism.AuthenticationMechanismOutcome)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpServletRequestWrapper bufferServletRequestInputStream(HttpServletRequest originalRequest, byte[] bytes) {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        return new HttpServletRequestWrapper(originalRequest){

            public ServletInputStream getInputStream() throws IOException {
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return byteArrayInputStream.read();
                    }
                };
            }
        };
    }

    private AuthenticationMechanism.AuthenticationMechanismOutcome handleSAMLResponse(HttpServerExchange exchange, SecurityContext securityContext) throws IOException {
        ServletRequestContext request = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest httpServletRequest = (HttpServletRequest)request.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)request.getServletResponse();
        String samlVersion = this.getSAMLVersion(httpServletRequest);
        if (!JBossSAMLConstants.VERSION_2_0.get().equals(samlVersion)) {
            return this.handleSAML11UnsolicitedResponse(httpServletRequest, response, securityContext);
        }
        return this.handleSAML2Response(exchange, securityContext);
    }

    private AuthenticationMechanism.ChallengeResult generalUserRequest(HttpServerExchange httpServerExchange, SecurityContext securityContext) throws IOException {
        ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
        serviceProviderSAMLWorkflow.setRedirectionHandler((ServiceProviderSAMLWorkflow.RedirectionHandler)new UndertowRedirectionHandler(httpServerExchange));
        ServletRequestContext servletRequestContext = (ServletRequestContext)httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl servletContext = servletRequestContext.getCurrentServletContext();
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        HttpSession session = request.getSession(true);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext(request, response, (ServletContext)servletContext);
        Set handlers = this.chain.handlers();
        boolean postBinding = this.spConfiguration.getBindingType().equals("POST");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            String idp;
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(postBinding, this.serviceURL, this.configuration, this.idpMetadata);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            if (StringUtil.isNotNull((String)(idp = (String)request.getAttribute("picketlink.desired.idp")))) {
                baseProcessor.setIdentityURL(idp);
            } else {
                baseProcessor.setIdentityURL(this.getIdentityURL());
            }
            baseProcessor.setAuditHelper(this.auditHelper);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        String relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.saveRestoreRequest) {
                    byte[] buffer = SPFormAuthrenticationRequestUtil.getStoredBuffer(httpServerExchange);
                    int contentLength = SPFormAuthrenticationRequestUtil.getStoredBufferLength(httpServerExchange);
                    if (buffer != null) {
                        this.storeInitialLocation(httpServerExchange, buffer, contentLength);
                    } else {
                        this.storeInitialLocation(httpServerExchange);
                    }
                }
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.REQUEST_TO_IDP);
                auditEvent.setWhoIsAuditing(servletContext.getContextPath());
                this.audit(auditEvent);
                serviceProviderSAMLWorkflow.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature, this.isHttpPostBinding());
                return new AuthenticationMechanism.ChallengeResult(false);
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw logger.samlSPProcessingExceptionError((Throwable)e);
            }
        }
        return super.sendChallenge(httpServerExchange, securityContext);
    }

    protected boolean matchRequest(HttpServletRequest request) {
        return false;
    }

    protected void register(SecurityContext securityContext, Account account) {
        securityContext.authenticationComplete(account, "FORM", false);
    }

    protected AuthenticationMechanism.AuthenticationMechanismOutcome localAuthentication(HttpServerExchange httpServerExchange, SecurityContext securityContext) throws IOException {
        ServletRequestContext servletRequestContext = (ServletRequestContext)httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl servletContext = servletRequestContext.getCurrentServletContext();
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        if (request.getUserPrincipal() == null) {
            logger.samlSPFallingBackToLocalFormAuthentication();
            try {
                return super.authenticate(httpServerExchange, securityContext);
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
        } else {
            return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
    }

    private AuthenticationMechanism.AuthenticationMechanismOutcome handleSAMLRequest(HttpServerExchange httpServerExchange, SecurityContext securityContext) throws IOException {
        ServletRequestContext servletRequestContext = (ServletRequestContext)httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl servletContext = servletRequestContext.getCurrentServletContext();
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext(request, response, (ServletContext)servletContext);
        Set handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(request.getMethod().equals("POST"), this.serviceURL, this.configuration, this.idpMetadata);
            requestProcessor.setTrustKeyManager(this.keyManager);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
            auditEvent.setType(PicketLinkAuditEventType.REQUEST_FROM_IDP);
            auditEvent.setWhoIsAuditing(servletContext.getContextPath());
            this.audit(auditEvent);
            if (response.isCommitted()) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            }
            if (result) {
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(httpServerExchange, securityContext);
    }

    private AuthenticationMechanism.AuthenticationMechanismOutcome handleSAML2Response(HttpServerExchange httpServerExchange, SecurityContext securityContext) throws IOException {
        block17: {
            ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
            ServletRequestContext servletRequestContext = (ServletRequestContext)httpServerExchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            ServletContextImpl servletContext = servletRequestContext.getCurrentServletContext();
            HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
            HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
            HttpSession session = request.getSession(true);
            String samlResponse = request.getParameter("SAMLResponse");
            boolean willSendRequest = false;
            HTTPContext httpContext = new HTTPContext(request, response, (ServletContext)servletContext);
            Set handlers = this.chain.handlers();
            Principal principal = request.getUserPrincipal();
            if (!serviceProviderSAMLWorkflow.validate(request)) {
                throw new IOException("PL00019: Validation check failed");
            }
            try {
                ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(request.getMethod().equals("POST"), this.serviceURL, this.configuration, this.idpMetadata);
                if (this.auditHelper != null) {
                    responseProcessor.setAuditHelper(this.auditHelper);
                }
                responseProcessor.setTrustKeyManager(this.keyManager);
                SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
                Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                String relayState = saml2HandlerResponse.getRelayState();
                String destination = saml2HandlerResponse.getDestination();
                willSendRequest = saml2HandlerResponse.getSendRequest();
                String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
                if (destination != null && samlResponseDocument != null) {
                    serviceProviderSAMLWorkflow.sendRequestToIDP(destination, samlResponseDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature, this.spConfiguration.getBindingType().equalsIgnoreCase("POST"));
                    break block17;
                }
                boolean sessionValidity = this.sessionIsValid(session);
                if (!sessionValidity) {
                    serviceProviderSAMLWorkflow.sendToLogoutPage(request, response, session, (ServletContext)servletContext, this.spConfiguration.getLogOutPage());
                    AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                    return authenticationMechanismOutcome;
                }
                List roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getAttribute("picketlink.principal");
                }
                String username = principal.getName();
                String password = EMPTY_PASSWORD;
                if (logger.isTraceEnabled()) {
                    logger.trace("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray()));
                }
                ServiceProviderSAMLContext.push(username, roles);
                IdentityManager identityManager = securityContext.getIdentityManager();
                Principal userPrincipal = principal;
                AccountImpl account = new AccountImpl(userPrincipal, new HashSet(roles), (Object)password);
                account = identityManager.verify((Account)account);
                this.register(securityContext, (Account)account);
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.RESPONSE_FROM_IDP);
                auditEvent.setSubjectName(username);
                auditEvent.setWhoIsAuditing(servletContext.getContextPath());
                this.audit(auditEvent);
                if (this.saveRestoreRequest) {
                    session.setAttribute(FORM_ACCOUNT_NOTE, (Object)account);
                    if (session.getAttribute(INITIAL_LOCATION_STORED) != null) {
                        this.handleRedirectBack(httpServerExchange);
                        httpServerExchange.endExchange();
                    }
                }
                AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                return authenticationMechanismOutcome;
            }
            catch (ProcessingException pe) {
                Throwable t = pe.getCause();
                if (t != null && t instanceof AssertionExpiredException) {
                    logger.error("Assertion has expired. Asking IDP for reissue");
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.EXPIRED_ASSERTION);
                    auditEvent.setAssertionID(((AssertionExpiredException)t).getId());
                    this.audit(auditEvent);
                    this.generalUserRequest(httpServerExchange, securityContext);
                    AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
                    return authenticationMechanismOutcome;
                }
                logger.samlSPHandleRequestError((Throwable)pe);
                throw logger.samlSPProcessingExceptionError((Throwable)pe);
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw logger.samlSPProcessingExceptionError((Throwable)e);
            }
            finally {
                ServiceProviderSAMLContext.clear();
            }
        }
        return this.localAuthentication(httpServerExchange, securityContext);
    }

    protected boolean isHttpPostBinding() {
        return this.spConfiguration.getBindingType().equalsIgnoreCase("POST");
    }

    protected boolean sessionIsValid(HttpSession session) {
        try {
            long l = session.getCreationTime();
        }
        catch (IllegalStateException ise) {
            return false;
        }
        return true;
    }

    protected String savedRequestURL(HttpSession session) {
        StringBuilder builder = new StringBuilder();
        HttpServletRequest request = (HttpServletRequest)session.getAttribute(FORM_REQUEST_NOTE);
        if (request != null) {
            builder.append(request.getRequestURI());
            if (request.getQueryString() != null) {
                builder.append("?").append(request.getQueryString());
            }
        }
        return builder.toString();
    }

    protected void startPicketLink() {
        SystemPropertiesUtil.ensure();
        Handlers handlers = null;
        String timerInterval = this.servletContext.getInitParameter("org.picketlink.federation.saml.REFRESH_CONFIG_TIMER_INTERVAL");
        if (timerInterval != null) {
            this.timerInterval = Integer.valueOf(timerInterval);
        }
        if (this.timerInterval > 0) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    SPFormAuthenticationMechanism.this.reloadConfiguration();
                    SPFormAuthenticationMechanism.this.processConfiguration();
                    SPFormAuthenticationMechanism.this.initKeyProvider(SPFormAuthenticationMechanism.this.servletContext);
                }
            }, this.timerInterval, (long)this.timerInterval);
        }
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            this.chain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                this.chain = SAML2HandlerChainFactory.createChain((String)this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new RuntimeException(e1);
            }
        }
        this.processConfiguration();
        try {
            if (this.configuration != null) {
                handlers = this.configuration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                handlers = ConfigurationUtil.getHandlers((InputStream)this.servletContext.getResourceAsStream(handlerConfigFileName));
            }
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            this.initKeyProvider(this.servletContext);
            this.populateChainConfig();
            this.initializeHandlerChain();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.configuration == null) {
            this.configuration = new PicketLinkType();
            this.configuration.setIdpOrSP((ProviderType)this.spConfiguration);
            this.configuration.setHandlers(handlers);
        }
    }

    protected void initKeyProvider(ServletContext context) {
        if (!this.doSupportSignature()) {
            return;
        }
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null && this.doSupportSignature()) {
            throw new RuntimeException("PL00092: Null Value:KeyProvider is null for context=" + context.getContextPath());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(((Object)((Object)this)).getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            List authProperties = CoreConfigUtil.getKeyProviderProperties((KeyProviderType)keyProvider);
            this.keyManager.setAuthProperties(authProperties);
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String identityURL = this.spConfiguration.getIdentityURL();
            if (authProperties != null) {
                for (AuthPropertyType authPropertyType : authProperties) {
                    String key = authPropertyType.getKey();
                    if (!"X509CERTIFICATE".equals(key)) continue;
                    this.keyManager.addAdditionalOption("X509CERTIFICATE", (Object)authPropertyType.getValue());
                    break;
                }
            }
            this.keyManager.addAdditionalOption("idp.key", (Object)new URL(identityURL).getHost());
        }
        catch (Exception e) {
            logger.trustKeyManagerCreationError((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        logger.trace("Key Provider=" + keyProvider.getClassName());
    }

    protected boolean doSupportSignature() {
        if (this.spConfiguration != null) {
            return this.spConfiguration.isSupportsSignature();
        }
        return false;
    }

    protected void processConfiguration() {
        String sysProp;
        this.enableAudit = this.configuration.isEnableAudit();
        if (!this.enableAudit && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
            this.enableAudit = Boolean.parseBoolean(sysProp);
        }
        if (this.enableAudit && this.auditHelper == null) {
            try {
                this.auditHelper = ConfigurationUtil.getAuditHelper((ServletContext)this.servletContext);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create audit helper.", e);
            }
        }
        this.processIdPMetadata(this.spConfiguration);
        this.identityURL = this.spConfiguration.getIdentityURL();
        this.serviceURL = this.spConfiguration.getServiceURL();
        this.canonicalizationMethod = this.spConfiguration.getCanonicalizationMethod();
        logger.samlSPSettingCanonicalizationMethod(this.canonicalizationMethod);
        XMLSignatureUtil.setCanonicalizationMethodType((String)this.canonicalizationMethod);
        logger.trace("Identity Provider URL=" + this.identityURL);
    }

    private void reloadConfiguration() {
        try {
            this.configuration = this.configProvider != null ? this.configProvider.getPicketLinkConfiguration() : ConfigurationUtil.getConfiguration((ServletContext)this.servletContext);
            this.spConfiguration = (SPType)this.configuration.getIdpOrSP();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reloading configuration.", e);
        }
    }

    private void processIdPMetadata(SPType spConfiguration) {
        IDPSSODescriptorType idpssoDescriptorType = null;
        idpssoDescriptorType = StringUtil.isNotNull((String)spConfiguration.getIdpMetadataFile()) ? this.getIdpMetadataFromFile(spConfiguration) : this.getIdpMetadataFromProvider(spConfiguration);
        if (idpssoDescriptorType != null) {
            List keyDescriptors;
            List endpoints = idpssoDescriptorType.getSingleSignOnService();
            for (EndpointType endpoint : endpoints) {
                String endpointBinding = endpoint.getBinding().toString();
                if (endpointBinding.contains("HTTP-POST")) {
                    endpointBinding = "POST";
                } else if (endpointBinding.contains("HTTP-Redirect")) {
                    endpointBinding = "REDIRECT";
                }
                if (!spConfiguration.getBindingType().equals(endpointBinding)) continue;
                spConfiguration.setIdentityURL(endpoint.getLocation().toString());
                break;
            }
            if ((keyDescriptors = idpssoDescriptorType.getKeyDescriptor()).size() > 0) {
                this.idpCertificate = MetaDataExtractor.getCertificate((KeyDescriptorType)((KeyDescriptorType)keyDescriptors.get(0)));
            }
            this.idpMetadata = idpssoDescriptorType;
        }
    }

    private IDPSSODescriptorType getIdpMetadataFromProvider(SPType spConfiguration) {
        List entityDescriptors = CoreConfigUtil.getMetadataConfiguration((ProviderType)spConfiguration, (ServletContext)this.servletContext);
        if (entityDescriptors != null) {
            for (EntityDescriptorType entityDescriptorType : entityDescriptors) {
                IDPSSODescriptorType idpssoDescriptorType = this.handleMetadata(entityDescriptorType);
                if (idpssoDescriptorType == null) continue;
                return idpssoDescriptorType;
            }
        }
        return null;
    }

    protected IDPSSODescriptorType getIdpMetadataFromFile(SPType configuration) {
        ServletContext servletContext = this.servletContext;
        InputStream is = servletContext.getResourceAsStream(configuration.getIdpMetadataFile());
        if (is == null) {
            return null;
        }
        Object metadata = null;
        try {
            Document samlDocument = DocumentUtil.getDocument((InputStream)is);
            SAMLParser parser = new SAMLParser();
            metadata = parser.parse(DocumentUtil.getNodeAsStream((Node)samlDocument));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IDPSSODescriptorType idpSSO = null;
        if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            idpSSO = this.handleMetadata(entities);
        } else {
            idpSSO = this.handleMetadata((EntityDescriptorType)metadata);
        }
        if (idpSSO == null) {
            logger.samlSPUnableToGetIDPDescriptorFromMetadata();
            return idpSSO;
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType handleMetadata(EntitiesDescriptorType entities) {
        Object entityDescriptor;
        IDPSSODescriptorType idpSSO = null;
        List entityDescs = entities.getEntityDescriptor();
        Iterator iterator = entityDescs.iterator();
        while (iterator.hasNext() && (idpSSO = (entityDescriptor = iterator.next()) instanceof EntitiesDescriptorType ? this.getIDPSSODescriptor(entities) : this.handleMetadata((EntityDescriptorType)entityDescriptor)) == null) {
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType getIDPSSODescriptor(EntitiesDescriptorType entities) {
        List entityDescs = entities.getEntityDescriptor();
        Iterator iterator = entityDescs.iterator();
        if (iterator.hasNext()) {
            Object entityDescriptor = iterator.next();
            if (entityDescriptor instanceof EntitiesDescriptorType) {
                return this.getIDPSSODescriptor((EntitiesDescriptorType)entityDescriptor);
            }
            return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)((EntityDescriptorType)entityDescriptor));
        }
        return null;
    }

    protected IDPSSODescriptorType handleMetadata(EntityDescriptorType entityDescriptor) {
        return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)entityDescriptor);
    }

    protected void initializeHandlerChain() throws ConfigurationException, ProcessingException {
        this.populateChainConfig();
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set samlHandlers = this.chain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
        }
    }

    protected void populateChainConfig() throws ConfigurationException, ProcessingException {
        this.chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
        this.chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
        if (this.doSupportSignature()) {
            this.chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            String certificateAlias = (String)this.keyManager.getAdditionalOption("X509CERTIFICATE");
            if (certificateAlias != null) {
                this.chainConfigOptions.put("X509CERTIFICATE", this.keyManager.getCertificate(certificateAlias));
            }
        }
    }

    private boolean isGlobalLogout(HttpServletRequest request) {
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    private String getSAMLVersion(HttpServletRequest request) {
        String version;
        String samlResponse = request.getParameter("SAMLResponse");
        try {
            Document samlDocument = this.toSAMLResponseDocument(samlResponse, "POST".equalsIgnoreCase(request.getMethod()));
            Element element = samlDocument.getDocumentElement();
            version = element.getAttribute("Version");
            if (StringUtil.isNullOrEmpty((String)version)) {
                String minorVersion = element.getAttribute("MinorVersion");
                String majorVersion = element.getAttribute("MajorVersion");
                version = minorVersion + "." + majorVersion;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract version from SAML Response.", e);
        }
        return version;
    }

    private Document toSAMLResponseDocument(String samlResponse, boolean isPostBinding) throws ParsingException {
        InputStream dataStream = null;
        dataStream = isPostBinding ? PostBindingUtil.base64DecodeAsStream((String)samlResponse) : RedirectBindingUtil.base64DeflateDecode((String)samlResponse);
        try {
            return DocumentUtil.getDocument((InputStream)dataStream);
        }
        catch (Exception e) {
            logger.samlResponseFromIDPParsingFailed();
            throw new ParsingException("", (Throwable)e);
        }
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome handleSAML11UnsolicitedResponse(HttpServletRequest request, HttpServletResponse response, SecurityContext securityContext) {
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (StringUtil.isNotNull((String)samlResponse)) {
            try {
                InputStream base64DecodedResponse = null;
                base64DecodedResponse = "GET".equalsIgnoreCase(request.getMethod()) ? RedirectBindingUtil.base64DeflateDecode((String)samlResponse) : PostBindingUtil.base64DecodeAsStream((String)samlResponse);
                SAMLParser parser = new SAMLParser();
                SAML11ResponseType saml11Response = (SAML11ResponseType)parser.parse(base64DecodedResponse);
                List assertions = saml11Response.get();
                if (assertions.size() > 1) {
                    logger.trace("More than one assertion from IDP. Considering the first one.");
                }
                List<String> roles = new ArrayList<String>();
                SAML11AssertionType assertion = (SAML11AssertionType)assertions.get(0);
                if (assertion != null) {
                    List statements = assertion.getStatements();
                    for (SAML11StatementAbstractType statement : statements) {
                        if (!(statement instanceof SAML11AuthenticationStatementType)) continue;
                        SAML11AuthenticationStatementType subStat = (SAML11AuthenticationStatementType)statement;
                        SAML11SubjectType subject = subStat.getSubject();
                        principal = new SerializablePrincipal(subject.getChoice().getNameID().getValue());
                    }
                    roles = AssertionUtil.getRoles((SAML11AssertionType)assertion, null);
                }
                String username = principal.getName();
                String password = EMPTY_PASSWORD;
                if (logger.isTraceEnabled()) {
                    logger.trace("Roles determined for username=" + username + "=" + Arrays.toString(roles.toArray()));
                }
                ServiceProviderSAMLContext.push(username, roles);
                IdentityManager identityManager = securityContext.getIdentityManager();
                Principal userPrincipal = principal;
                AccountImpl account = new AccountImpl(userPrincipal, new HashSet<String>(roles), (Object)password);
                account = identityManager.verify((Account)account);
                this.register(securityContext, (Account)account);
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.RESPONSE_FROM_IDP);
                auditEvent.setSubjectName(username);
                auditEvent.setWhoIsAuditing(this.servletContext.getContextPath());
                this.audit(auditEvent);
                return AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
            }
        }
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
    }

    public void audit(PicketLinkAuditEvent event) {
        if (this.enableAudit) {
            this.auditHelper.audit((AuditEvent)event);
        }
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return requestedWithHeader != null && "XMLHttpRequest".equalsIgnoreCase(requestedWithHeader);
    }

    public String getIdentityURL() {
        return this.spConfiguration.getIdentityURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$authenticate$0(HttpServerExchange exchange, ServletRequestContext servletRequestContext, HttpServletResponse response, HttpSession session, ServletContext servletContext, CompletableFuture future, SecurityContext securityContext, HttpServerExchange exch, byte[] bytes) {
        block20: {
            try {
                if (bytes == null || bytes.length <= 0 || exchange.getRequestContentLength() <= 0L) break block20;
                HttpServletRequest originalRequest = (HttpServletRequest)servletRequestContext.getServletRequest();
                try {
                    FormData parsedForm;
                    Connectors.ungetRequestBytes((HttpServerExchange)exchange, (PooledByteBuffer[])new PooledByteBuffer[]{new ImmediatePooledByteBuffer(ByteBuffer.wrap(bytes, 0, (int)exchange.getRequestContentLength()))});
                    Connectors.resetRequestChannel((HttpServerExchange)exchange);
                    servletRequestContext.setServletRequest((ServletRequest)this.bufferServletRequestInputStream(originalRequest, bytes));
                    FormDataParser formDataParser = this.formParserFactory.createParser(exchange);
                    if (formDataParser != null && (parsedForm = formDataParser.parseBlocking()) != null) {
                        SPFormAuthrenticationRequestUtil.store(bytes, parsedForm, exchange, (int)exchange.getRequestContentLength());
                    }
                }
                finally {
                    servletRequestContext.setServletRequest((ServletRequest)originalRequest);
                }
            }
            catch (RuntimeException e) {
                logger.samlLogoutError((Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.samlLogoutError((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        HttpServletRequest request = SPFormAuthrenticationRequestUtil.wrapRequest(exchange);
        servletRequestContext.setServletRequest((ServletRequest)request);
        ServiceProviderSAMLWorkflow serviceProviderSAMLWorkflow = new ServiceProviderSAMLWorkflow();
        boolean localLogout = serviceProviderSAMLWorkflow.isLocalLogoutRequest(request);
        if (localLogout) {
            try {
                serviceProviderSAMLWorkflow.sendToLogoutPage(request, response, session, servletContext, this.spConfiguration.getLogOutPage());
            }
            catch (ServletException e) {
                logger.samlLogoutError((Throwable)e);
                throw new RuntimeException(e);
            }
            catch (IOException e1) {
                logger.samlLogoutError((Throwable)e1);
                throw new RuntimeException(e1);
            }
            future.complete(AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED);
            return;
        }
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        try {
            if (!(principal == null || serviceProviderSAMLWorkflow.isLocalLogoutRequest(request) || this.isGlobalLogout(request) || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
                IdentityManager identityManager = securityContext.getIdentityManager();
                AccountImpl account = new AccountImpl(principal, new HashSet(), (Object)EMPTY_PASSWORD);
                account = identityManager.verify((Account)account);
                future.complete(AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED);
                return;
            }
            if (StringUtil.isNotNull((String)samlResponse)) {
                future.complete(this.handleSAMLResponse(exchange, securityContext));
                return;
            }
            if (StringUtil.isNotNull((String)samlRequest)) {
                future.complete(this.handleSAMLRequest(exchange, securityContext));
                return;
            }
            AuthenticationMechanism.AuthenticationMechanismOutcome outcome = super.authenticate(exchange, securityContext);
            future.complete(outcome);
            return;
        }
        catch (IOException e) {
            if (StringUtil.isNotNull((String)this.spConfiguration.getErrorPage())) {
                try {
                    request.getRequestDispatcher(this.spConfiguration.getErrorPage()).forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (ServletException e1) {
                    logger.samlErrorPageForwardError(this.spConfiguration.getErrorPage(), (Throwable)e1);
                }
                catch (IOException e1) {
                    logger.samlErrorPageForwardError(this.spConfiguration.getErrorPage(), (Throwable)e1);
                }
                future.complete(AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED);
                return;
            }
            throw new RuntimeException(e);
        }
    }
}

