/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.net.URI;

final class LdapEntry {
    private final String simpleName;
    private final String distinguishedName;
    private final URI referralURI;
    private final int hashCode;

    LdapEntry(String simpleName, String distinguishedName) {
        this(simpleName, distinguishedName, null);
    }

    LdapEntry(String simpleName, String distinguishedName, URI referralURI) {
        this.simpleName = simpleName;
        this.distinguishedName = distinguishedName;
        this.referralURI = referralURI;
        this.hashCode = (simpleName == null ? 7 : simpleName.hashCode()) * (distinguishedName == null ? 31 : distinguishedName.hashCode() * (referralURI == null ? 37 : referralURI.hashCode()));
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public URI getReferralUri() {
        return this.referralURI;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof LdapEntry ? this.equals((LdapEntry)obj) : false;
    }

    private boolean equals(LdapEntry obj) {
        if (obj == this) {
            return true;
        }
        return obj.hashCode == this.hashCode && (this.simpleName == null ? obj.simpleName == null : this.simpleName.equals(obj.simpleName)) && (this.distinguishedName == null ? obj.distinguishedName == null : this.distinguishedName.equals(obj.distinguishedName) && (this.referralURI == null ? obj.referralURI == null : this.referralURI.equals(obj.referralURI)));
    }

    public String toString() {
        return String.format("LdapEntry simpleName='%s', distinguishedName='%s', referralConnection='%s'", this.simpleName, this.distinguishedName, this.referralURI);
    }
}

