/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.subsystem;

import com.arjuna.ats.arjuna.coordinator.TxStats;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.txn.logging.TransactionLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TxStatsHandler
extends AbstractRuntimeOnlyHandler {
    public static final TxStatsHandler INSTANCE = new TxStatsHandler();
    private final TxStats txStats = TxStats.getInstance();

    private TxStatsHandler() {
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        TxStat stat = TxStat.getStat(operation.require("name").asString());
        if (stat == null) {
            context.getFailureDescription().set(TransactionLogger.ROOT_LOGGER.unknownMetric(operation.require("name").asString()));
        } else {
            ModelNode result = new ModelNode();
            switch (stat) {
                case NUMBER_OF_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTransactions());
                    break;
                }
                case NUMBER_OF_NESTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfNestedTransactions());
                    break;
                }
                case NUMBER_OF_HEURISTICS: {
                    result.set(this.txStats.getNumberOfHeuristics());
                    break;
                }
                case NUMBER_OF_COMMITTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfCommittedTransactions());
                    break;
                }
                case NUMBER_OF_ABORTED_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfAbortedTransactions());
                    break;
                }
                case NUMBER_OF_INFLIGHT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfInflightTransactions());
                    break;
                }
                case NUMBER_OF_TIMED_OUT_TRANSACTIONS: {
                    result.set(this.txStats.getNumberOfTimedOutTransactions());
                    break;
                }
                case NUMBER_OF_APPLICATION_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfApplicationRollbacks());
                    break;
                }
                case NUMBER_OF_RESOURCE_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfResourceRollbacks());
                    break;
                }
                case NUMBER_OF_SYSTEM_ROLLBACKS: {
                    result.set(this.txStats.getNumberOfSystemRollbacks());
                    break;
                }
                case AVERAGE_COMMIT_TIME: {
                    result.set(this.txStats.getAverageCommitTime());
                    break;
                }
                default: {
                    throw new IllegalStateException(TransactionLogger.ROOT_LOGGER.unknownMetric((Object)stat));
                }
            }
            context.getResult().set(result);
        }
    }

    void registerMetrics(ManagementResourceRegistration resourceRegistration) {
        for (TxStat stat : TxStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)this);
        }
    }

    public static enum TxStat {
        NUMBER_OF_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_NESTED_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-nested-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_HEURISTICS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-heuristics", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_COMMITTED_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-committed-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_ABORTED_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-aborted-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_INFLIGHT_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-inflight-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_TIMED_OUT_TRANSACTIONS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-timed-out-transactions", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_APPLICATION_ROLLBACKS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-application-rollbacks", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_RESOURCE_ROLLBACKS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-resource-rollbacks", (ModelType)ModelType.LONG, (boolean)true).build()),
        NUMBER_OF_SYSTEM_ROLLBACKS((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"number-of-system-rollbacks", (ModelType)ModelType.LONG, (boolean)true).build()),
        AVERAGE_COMMIT_TIME((AttributeDefinition)SimpleAttributeDefinitionBuilder.create((String)"average-commit-time", (ModelType)ModelType.LONG, (boolean)true).build());

        private static final Map<String, TxStat> MAP;
        final AttributeDefinition definition;

        private TxStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized TxStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, TxStat>();
            for (TxStat stat : EnumSet.allOf(TxStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }
}

