/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.ls;

import java.io.IOException;
import java.math.RoundingMode;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.command.shell.Shell;
import org.aesh.comparators.PosixFileNameComparator;
import org.aesh.extensions.ls.StringGroup;
import org.aesh.extensions.tty.AeshPosixFilePermissions;
import org.aesh.io.Resource;
import org.aesh.io.filter.NoDotNamesFilter;
import org.aesh.io.filter.ResourceFilter;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.util.Parser;
import org.aesh.utils.Config;

@CommandDefinition(name="ls", description="[OPTION]... [FILE]...\nList information about the FILEs (the current directory by default).\nSort entries alphabetically if none of -cftuvSUX nor --sort is specified.\n")
public class Ls
implements Command<CommandInvocation> {
    @Option(shortName=72, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=97, name="all", hasValue=false, description="do not ignore entries starting with .")
    private boolean all;
    @Option(shortName=100, name="directory", hasValue=false, description="list directory entries instead of contents, and do not dereference symbolic links")
    private boolean directory;
    @Option(shortName=108, name="longlisting", hasValue=false, description="use a long listing format")
    private boolean longListing;
    @Option(shortName=115, name="size", hasValue=false, description="print the allocated size of each file, in blocks")
    private boolean size;
    @Option(shortName=104, name="human-readable", hasValue=false, description="with -l, print sizes in human readable format (e.g., 1K 234M 2G)")
    private boolean humanReadable;
    @Arguments
    private List<Resource> arguments;
    private static final char SPACE = ' ';
    private static final Class<? extends BasicFileAttributes> fileAttributes = Config.isOSPOSIXCompatible() ? PosixFileAttributes.class : DosFileAttributes.class;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd HH:mm");
    private static final DateFormat OLD_FILE_DATE_FORMAT = new SimpleDateFormat("MMM dd  yyyy");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat(".#");
    private static final TerminalColor DIRECTORY_COLOR = new TerminalColor(Color.BLUE, Color.DEFAULT, Color.Intensity.BRIGHT);
    private static final TerminalColor SYMBOLIC_LINK_COLOR = new TerminalColor(Color.CYAN, Color.DEFAULT, Color.Intensity.BRIGHT);

    public Ls() {
        DECIMAL_FORMAT.setRoundingMode(RoundingMode.UP);
    }

    public CommandResult execute(CommandInvocation commandInvocation) {
        if (this.help) {
            commandInvocation.getShell().writeln(commandInvocation.getHelpInfo("ls"));
            return CommandResult.SUCCESS;
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList<Resource>(1);
            this.arguments.add(commandInvocation.getAeshContext().getCurrentWorkingDirectory());
        }
        int counter = 0;
        for (Resource file : this.arguments) {
            if (counter > 0) {
                commandInvocation.getShell().writeln(Config.getLineSeparator() + file.getName() + ":");
            }
            for (Resource f : file.resolve(commandInvocation.getAeshContext().getCurrentWorkingDirectory())) {
                if (f.isDirectory()) {
                    this.displayDirectory(f, commandInvocation.getShell());
                    continue;
                }
                if (f.isLeaf()) {
                    this.displayFile(f, commandInvocation.getShell());
                    continue;
                }
                if (f.exists()) continue;
                commandInvocation.getShell().writeln("ls: cannot access " + f.toString() + ": No such file or directory");
            }
            ++counter;
        }
        return CommandResult.SUCCESS;
    }

    private void displayDirectory(Resource input, Shell shell) {
        List<Resource> files = new ArrayList<Resource>();
        if (this.all) {
            files.add(input.newInstance("."));
            files.add(input.newInstance(".."));
            files.addAll(input.list());
        } else {
            files = input.list((ResourceFilter)new NoDotNamesFilter());
        }
        Collections.sort(files, new PosixFileComparator());
        if (this.longListing) {
            shell.write(this.displayLongListing(files));
        } else {
            shell.write(Parser.formatDisplayCompactListTerminalString(this.formatFileList(files), (int)shell.size().getWidth()));
        }
    }

    private List<TerminalString> formatFileList(List<Resource> fileList) {
        ArrayList<TerminalString> list = new ArrayList<TerminalString>(fileList.size());
        for (Resource file : fileList) {
            if (file.isSymbolicLink()) {
                list.add(new TerminalString(file.getName(), SYMBOLIC_LINK_COLOR));
                continue;
            }
            if (file.isDirectory()) {
                list.add(new TerminalString(file.getName(), DIRECTORY_COLOR));
                continue;
            }
            list.add(new TerminalString(file.getName()));
        }
        return list;
    }

    private void displayFile(Resource input, Shell shell) {
        if (this.longListing) {
            ArrayList<Resource> resourceList = new ArrayList<Resource>(1);
            resourceList.add(input);
            shell.write(this.displayLongListing(resourceList));
        } else {
            ArrayList<Resource> resourceList = new ArrayList<Resource>(1);
            resourceList.add(input);
            shell.write(Parser.formatDisplayListTerminalString(this.formatFileList(resourceList), (int)shell.size().getHeight(), (int)shell.size().getWidth()));
        }
    }

    private String displayLongListing(List<Resource> files) {
        StringGroup access = new StringGroup(files.size());
        StringGroup size = new StringGroup(files.size());
        StringGroup owner = new StringGroup(files.size());
        StringGroup group = new StringGroup(files.size());
        StringGroup modified = new StringGroup(files.size());
        try {
            int counter = 0;
            for (Resource file : files) {
                BasicFileAttributes attr = file.readAttributes(fileAttributes, new LinkOption[]{LinkOption.NOFOLLOW_LINKS});
                if (Config.isOSPOSIXCompatible()) {
                    access.addString(AeshPosixFilePermissions.toString((PosixFileAttributes)attr), counter);
                } else {
                    access.addString("", counter);
                }
                size.addString(this.makeSizeReadable(attr.size()), counter);
                if (Config.isOSPOSIXCompatible()) {
                    owner.addString(((PosixFileAttributes)attr).owner().getName(), counter);
                    group.addString(((PosixFileAttributes)attr).group().getName(), counter);
                } else {
                    owner.addString("", counter);
                    group.addString("", counter);
                }
                Date lastModifiedTime = new Date(attr.lastModifiedTime().toMillis());
                Calendar lastModifiedCalendar = Calendar.getInstance();
                lastModifiedCalendar.setTime(lastModifiedTime);
                Calendar nowCalendar = Calendar.getInstance();
                if (lastModifiedCalendar.get(1) == nowCalendar.get(1)) {
                    modified.addString(DATE_FORMAT.format(lastModifiedTime), counter);
                } else {
                    modified.addString(OLD_FILE_DATE_FORMAT.format(lastModifiedTime), counter);
                }
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < files.size(); ++i) {
            builder.append(access.getString(i)).append(owner.getFormattedStringPadRight(i)).append(group.getFormattedStringPadRight(i)).append(size.getFormattedString(i)).append(' ').append(modified.getString(i)).append(' ');
            if (files.get(i).isSymbolicLink()) {
                builder.append(new TerminalString(files.get(i).getName(), SYMBOLIC_LINK_COLOR));
                builder.append(" -> ");
                try {
                    builder.append(files.get(i).readSymbolicLink());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else if (files.get(i).isDirectory()) {
                builder.append(new TerminalString(files.get(i).getName(), DIRECTORY_COLOR));
            } else {
                builder.append(files.get(i).getName());
            }
            builder.append(Config.getLineSeparator());
        }
        return builder.toString();
    }

    private String makeSizeReadable(long size) {
        if (!this.humanReadable) {
            return String.valueOf(size);
        }
        if (size < 10000L) {
            return String.valueOf(size);
        }
        if (size < 10000000L) {
            return DECIMAL_FORMAT.format((double)size / 1024.0) + "K";
        }
        if (size < 1000000000L) {
            return DECIMAL_FORMAT.format((double)size / 1048576.0) + "M";
        }
        return DECIMAL_FORMAT.format((double)size / 1.063256064E9) + "G";
    }

    class PosixFileComparator
    implements Comparator<Resource> {
        private PosixFileNameComparator posixFileNameComparator = new PosixFileNameComparator();

        PosixFileComparator() {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            return this.posixFileNameComparator.compare(o1.getName(), o2.getName());
        }
    }
}

