/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.Serializable;
import java.security.AccessController;
import java.util.concurrent.TimeUnit;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import org.jboss.ejb._private.Keys;
import org.jboss.ejb._private.Logs;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.ClusterAffinityInterest;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBIdentifier;
import org.jboss.ejb.client.EJBModuleIdentifier;
import org.jboss.ejb.client.StatelessEJBLocator;
import org.wildfly.naming.client.AbstractContext;
import org.wildfly.naming.client.CloseableNamingEnumeration;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.naming.client.SimpleName;
import org.wildfly.naming.client.store.RelativeContext;
import org.wildfly.naming.client.util.FastHashtable;

class EJBRootContext
extends AbstractContext {
    private static final String PROPERTY_KEY_INVOCATION_TIMEOUT = "invocation.timeout";
    private static final String LEARNED_AFFINITY_KEY = "__jboss.learned-affinity";
    private final LearnedAffinity baseAffinity;
    private final NamingProvider namingProvider;
    private final ProviderEnvironment providerEnvironment;

    EJBRootContext(NamingProvider namingProvider, FastHashtable<String, Object> env, ProviderEnvironment providerEnvironment) {
        super(env);
        this.namingProvider = namingProvider;
        this.providerEnvironment = providerEnvironment;
        Object learned = env.get(LEARNED_AFFINITY_KEY);
        if (learned == null || !(learned instanceof LearnedAffinity)) {
            String clusterName = this.getClusterAffinityValueFromEnvironment();
            learned = clusterName != null ? new LearnedAffinity(new ClusterAffinity(clusterName)) : new LearnedAffinity(this.shouldLearnAffinity() ? null : Affinity.NONE);
            env.put(LEARNED_AFFINITY_KEY, learned);
        }
        this.baseAffinity = (LearnedAffinity)learned;
    }

    @Override
    protected Object lookupNative(Name name) throws NamingException {
        Long invocationTimeout;
        Object proxy;
        Class<?> view;
        int cp;
        int size = name.size();
        if (size < 3) {
            return new RelativeContext(new FastHashtable<String, Object>(this.getEnvironment()), this, SimpleName.of(name));
        }
        if (size > 4) {
            throw EJBRootContext.nameNotFound(name);
        }
        String appName = name.get(0);
        String moduleName = name.get(1);
        String lastPart = name.get(size - 1);
        String beanName = null;
        int i = 0;
        while (i < lastPart.length()) {
            cp = lastPart.codePointAt(i);
            if (cp == 33) {
                beanName = lastPart.substring(0, i);
                lastPart = lastPart.substring(i + 1);
                break;
            }
            if (cp == 63) {
                throw EJBRootContext.nameNotFound(name);
            }
            i = lastPart.offsetByCodePoints(i, 1);
        }
        if (beanName == null) {
            if (size == 3) {
                return new RelativeContext(new FastHashtable<String, Object>(this.getEnvironment()), this, SimpleName.of(name));
            }
            throw EJBRootContext.nameNotFound(name);
        }
        String distinctName = size == 4 ? name.get(2) : "";
        String viewType = null;
        int i2 = 0;
        while (i2 < lastPart.length()) {
            cp = lastPart.codePointAt(i2);
            if (cp == 63) {
                viewType = lastPart.substring(0, i2);
                lastPart = lastPart.substring(i2 + 1);
                break;
            }
            i2 = lastPart.offsetByCodePoints(i2, 1);
        }
        boolean stateful = false;
        if (viewType == null) {
            viewType = lastPart;
        } else {
            int eq = -1;
            int st = 0;
            int i3 = 0;
            while (i3 < lastPart.length()) {
                cp = lastPart.codePointAt(i3);
                if (cp == 61 && eq == -1) {
                    eq = i3;
                }
                if (cp == 38) {
                    if ("stateful".equals(lastPart.substring(st, eq == -1 ? i3 : eq)) && (eq == -1 || "true".equalsIgnoreCase(lastPart.substring(eq + 1, i3)))) {
                        stateful = true;
                    }
                    st = cp + 1;
                    eq = -1;
                }
                i3 = lastPart.offsetByCodePoints(i3, 1);
            }
            if ("stateful".equals(lastPart.substring(st, eq == -1 ? lastPart.length() : eq)) && (eq == -1 || "true".equalsIgnoreCase(lastPart.substring(eq + 1)))) {
                stateful = true;
            }
        }
        try {
            view = Class.forName(viewType, false, EJBRootContext.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw Logs.MAIN.lookupFailed(name, name, e);
        }
        NamingProvider namingProvider = this.namingProvider;
        EJBModuleIdentifier moduleIdentifier = new EJBModuleIdentifier(appName, moduleName, distinctName);
        EJBIdentifier identifier = new EJBIdentifier(moduleIdentifier, beanName);
        StatelessEJBLocator<?> statelessLocator = StatelessEJBLocator.create(view, identifier, this.baseAffinity.get());
        if (stateful) {
            try {
                proxy = EJBClient.createSessionProxy(statelessLocator, this.providerEnvironment.getAuthenticationContextSupplier(), namingProvider);
            }
            catch (Exception e) {
                throw Logs.MAIN.lookupFailed(name, name, e);
            }
        } else {
            proxy = EJBClient.createProxy(statelessLocator, this.providerEnvironment.getAuthenticationContextSupplier());
        }
        if (namingProvider != null) {
            EJBClient.putProxyAttachment(proxy, Keys.NAMING_PROVIDER_ATTACHMENT_KEY, namingProvider);
        }
        if (this.baseAffinity.isUnset()) {
            EJBClient.putProxyAttachment(proxy, ClusterAffinityInterest.KEY, this.baseAffinity);
        }
        if ((invocationTimeout = this.getLongValueFromEnvironment(PROPERTY_KEY_INVOCATION_TIMEOUT)) != null) {
            EJBClient.setInvocationTimeout(proxy, invocationTimeout, TimeUnit.MILLISECONDS);
        }
        return proxy;
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        ClassLoader classLoader = sm != null ? AccessController.doPrivileged(EJBRootContext::doGetContextClassLoader) : EJBRootContext.doGetContextClassLoader();
        return classLoader;
    }

    private static ClassLoader doGetContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    protected Object lookupLinkNative(Name name) throws NamingException {
        return this.lookupNative(name);
    }

    @Override
    protected CloseableNamingEnumeration<NameClassPair> listNative(Name name) throws NamingException {
        throw EJBRootContext.notSupported();
    }

    @Override
    protected CloseableNamingEnumeration<Binding> listBindingsNative(Name name) throws NamingException {
        throw EJBRootContext.notSupported();
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    private Long getLongValueFromEnvironment(String key) throws NamingException {
        Object val = ((FastHashtable)this.getEnvironment()).get(key);
        if (val != null && val instanceof String) {
            return Long.parseLong((String)val);
        }
        return null;
    }

    private boolean shouldLearnAffinity() {
        Object val = null;
        try {
            val = ((FastHashtable)this.getEnvironment()).get("jboss.disable-affinity-learning");
        }
        catch (NamingException ne) {
            Logs.MAIN.warn("Problem reading cluster affinity specification from env; skipping affinity assignment");
        }
        return val == null || "false".equalsIgnoreCase(val.toString());
    }

    private String getClusterAffinityValueFromEnvironment() {
        try {
            Object val = ((FastHashtable)this.getEnvironment()).get("jboss.cluster-affinity");
            if (val != null && val instanceof String) {
                return (String)val;
            }
            return this.getLegacyClusterAffinity();
        }
        catch (NamingException ne) {
            Logs.MAIN.warn("Problem reading cluster affinity specification from env; skipping affinity assignment");
            return null;
        }
    }

    private String getLegacyClusterAffinity() throws NamingException {
        Object val = ((FastHashtable)this.getEnvironment()).get("remote.clusters");
        if (val != null && val instanceof String) {
            String str = (String)val;
            int index = str.indexOf(44);
            if (index > -1) {
                str = str.substring(0, index);
            }
            return str.trim();
        }
        return null;
    }

    private static class LearnedAffinity
    implements ClusterAffinityInterest,
    Serializable {
        volatile transient Affinity affinity;

        LearnedAffinity(Affinity affinity) {
            this.affinity = affinity;
        }

        @Override
        public void notifyAssignment(ClusterAffinity affinity) {
            if (affinity != null && this.affinity == null) {
                this.affinity = affinity;
            }
        }

        Affinity get() {
            return this.affinity == null ? Affinity.NONE : this.affinity;
        }

        boolean isUnset() {
            return this.affinity == null;
        }

        private Object writeReplace() {
            return null;
        }
    }
}

