/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.security.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.util.ProviderUtil;
import org.wildfly.security.util.ServiceLoaderSupplier;

public class ProviderServiceLoaderSupplier
extends ServiceLoaderSupplier<Provider> {
    final boolean elytronProviderStaticallyAdded;

    public ProviderServiceLoaderSupplier(ClassLoader classLoader) {
        this(classLoader, false);
    }

    public ProviderServiceLoaderSupplier(ClassLoader classLoader, boolean elytronProviderStaticallyAdded) {
        super(Provider.class, classLoader);
        this.elytronProviderStaticallyAdded = elytronProviderStaticallyAdded;
    }

    Provider[] loadServices(Class<Provider> service, ClassLoader classLoader) {
        Provider[] providers = ProviderUtil.INSTALLED_PROVIDERS.get();
        HashSet installedProvidersSet = new HashSet((providers != null ? providers.length : 0) + (this.elytronProviderStaticallyAdded ? 1 : 0));
        if (this.elytronProviderStaticallyAdded) {
            installedProvidersSet.add(WildFlyElytronProvider.class);
        }
        if (providers != null) {
            for (int i = 0; i < providers.length; ++i) {
                installedProvidersSet.add(providers[i].getClass());
            }
        }
        ArrayList<Provider> list = new ArrayList<Provider>();
        ServiceLoader<Provider> loader = ServiceLoader.load(service, classLoader);
        Iterator<Provider> iterator = loader.iterator();
        while (true) {
            try {
                while (true) {
                    if (!iterator.hasNext()) {
                        return list.toArray(new Provider[list.size()]);
                    }
                    Provider provider = iterator.next();
                    if (installedProvidersSet.contains(provider.getClass())) continue;
                    list.add(provider);
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                continue;
            }
            break;
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ProviderServiceLoaderSupplier && this.equals((ProviderServiceLoaderSupplier)obj);
    }

    private boolean equals(ProviderServiceLoaderSupplier other) {
        return other == this || other.classLoader == this.classLoader;
    }
}

