/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;

public class ActiveMQJMSClientBundle_$bundle
implements ActiveMQJMSClientBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQJMSClientBundle_$bundle INSTANCE = new ActiveMQJMSClientBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String invalidFilter = "AMQ129000: Invalid filter: {0}";
    private static final String invalidSubscriptionName = "AMQ129001: Invalid Subscription Name. It is required to set the subscription name";
    private static final String destinationDoesNotExist = "AMQ129002: Destination {0} does not exist";
    private static final String nameCannotBeNull = "AMQ129003: name cannot be null";
    private static final String nameCannotBeEmpty = "AMQ129004: name cannot be empty";
    private static final String callingMethodFromListenerRuntime = "AMQ129005: It is illegal to call this method from within a Message Listener";
    private static final String callingMethodFromListener = "AMQ129006: It is illegal to call this method from within a Message Listener";
    private static final String callingMethodFromCompletionListenerRuntime = "AMQ129007: It is illegal to call this method from within a Completion Listener";
    private static final String callingMethodFromCompletionListener = "AMQ129008: It is illegal to call this method from within a Completion Listener";
    private static final String nullArgumentNotAllowed = "AMQ129009: Null {0} is not allowed";
    private static final String nullTopic = "AMQ129010: Topic (Destination) cannot be null";
    private static final String onlyValidForByteOrStreamMessages = "AMQ129011: LargeMessage streaming is only possible on ByteMessage or StreamMessage";
    private static final String invalidJavaIdentifier = "AMQ129012: The property name ''{0}'' is not a valid java identifier.";
    private static final String messageNotWritable = "AMQ129013: Message is read-only";
    private static final String messageNotReadable = "AMQ129014: Message is write-only";
    private static final String illegalDeliveryMode = "AMQ129015: Illegal deliveryMode value: {0}";

    protected ActiveMQJMSClientBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidFilter$str() {
        return invalidFilter;
    }

    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(Throwable e, SimpleString filter) {
        ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(this._formatMessage(this.invalidFilter$str(), filter));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String invalidSubscriptionName$str() {
        return invalidSubscriptionName;
    }

    @Override
    public final ActiveMQIllegalStateException invalidSubscriptionName() {
        ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(this.getLoggingLocale(), this.invalidSubscriptionName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String destinationDoesNotExist$str() {
        return destinationDoesNotExist;
    }

    @Override
    public final ActiveMQNonExistentQueueException destinationDoesNotExist(SimpleString destination) {
        ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(this._formatMessage(this.destinationDoesNotExist$str(), destination));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameCannotBeNull$str() {
        return nameCannotBeNull;
    }

    @Override
    public final IllegalArgumentException nameCannotBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nameCannotBeEmpty$str() {
        return nameCannotBeEmpty;
    }

    @Override
    public final IllegalArgumentException nameCannotBeEmpty() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nameCannotBeEmpty$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromListenerRuntime$str() {
        return callingMethodFromListenerRuntime;
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(this.getLoggingLocale(), this.callingMethodFromListenerRuntime$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromListener$str() {
        return callingMethodFromListener;
    }

    @Override
    public final IllegalStateException callingMethodFromListener() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.callingMethodFromListener$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromCompletionListenerRuntime$str() {
        return callingMethodFromCompletionListenerRuntime;
    }

    @Override
    public final IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime() {
        IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(this.getLoggingLocale(), this.callingMethodFromCompletionListenerRuntime$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String callingMethodFromCompletionListener$str() {
        return callingMethodFromCompletionListener;
    }

    @Override
    public final IllegalStateException callingMethodFromCompletionListener() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.callingMethodFromCompletionListener$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullArgumentNotAllowed$str() {
        return nullArgumentNotAllowed;
    }

    @Override
    public final IllegalArgumentException nullArgumentNotAllowed(String type) {
        IllegalArgumentException result = new IllegalArgumentException(this._formatMessage(this.nullArgumentNotAllowed$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullTopic$str() {
        return nullTopic;
    }

    @Override
    public final InvalidDestinationException nullTopic() {
        InvalidDestinationException result = new InvalidDestinationException(String.format(this.getLoggingLocale(), this.nullTopic$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String onlyValidForByteOrStreamMessages$str() {
        return onlyValidForByteOrStreamMessages;
    }

    @Override
    public final IllegalStateException onlyValidForByteOrStreamMessages() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.onlyValidForByteOrStreamMessages$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidJavaIdentifier$str() {
        return invalidJavaIdentifier;
    }

    @Override
    public final JMSRuntimeException invalidJavaIdentifier(String propertyName) {
        JMSRuntimeException result = new JMSRuntimeException(this._formatMessage(this.invalidJavaIdentifier$str(), propertyName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageNotWritable$str() {
        return messageNotWritable;
    }

    @Override
    public final MessageNotWriteableException messageNotWritable() {
        MessageNotWriteableException result = new MessageNotWriteableException(String.format(this.getLoggingLocale(), this.messageNotWritable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String messageNotReadable$str() {
        return messageNotReadable;
    }

    @Override
    public final MessageNotReadableException messageNotReadable() {
        MessageNotReadableException result = new MessageNotReadableException(String.format(this.getLoggingLocale(), this.messageNotReadable$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalDeliveryMode$str() {
        return illegalDeliveryMode;
    }

    @Override
    public final JMSException illegalDeliveryMode(int deliveryMode) {
        JMSException result = new JMSException(this._formatMessage(this.illegalDeliveryMode$str(), deliveryMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

