/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.IOException;
import java.util.Arrays;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentHandler;
import org.jboss.as.domain.controller.operations.deployment.DeploymentUploadUtil;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;

public class DeploymentFullReplaceHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;

    public DeploymentFullReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.fileRepository = null;
    }

    public DeploymentFullReplaceHandler(HostFileRepository fileRepository) {
        this.contentRepository = null;
        this.fileRepository = fileRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        ModelNode correctedOperation = operation.clone();
        for (AttributeDefinition def : DeploymentAttributes.FULL_REPLACE_DEPLOYMENT_ATTRIBUTES.values()) {
            def.validateAndSet(operation, correctedOperation);
        }
        String name = DeploymentAttributes.NAME.resolveModelAttribute(context, correctedOperation).asString();
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        final PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath});
        String runtimeName = correctedOperation.hasDefined("runtime-name") ? DeploymentAttributes.RUNTIME_NAME.resolveModelAttribute(context, correctedOperation).asString() : name;
        ModelNode content = correctedOperation.require("content").clone();
        ModelNode deploymentModel = context.readResourceForUpdate(PathAddress.pathAddress((PathElement[])new PathElement[]{deploymentPath})).getModel();
        ModelNode replacedContent = deploymentModel.get("content").get(0);
        final byte[] replacedHash = replacedContent.hasDefined(DeploymentAttributes.CONTENT_HASH.getName()) ? DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, replacedContent).asBytes() : null;
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            newHash = contentItemNode.require("hash").asBytes();
            if (this.contentRepository != null) {
                if (!this.contentRepository.hasContent(newHash)) {
                    throw AbstractDeploymentHandler.createFailureException(DomainControllerLogger.ROOT_LOGGER.noDeploymentContentWithHash(HashUtil.bytesToHexString((byte[])newHash)));
                }
            } else {
                this.fileRepository.getDeploymentFiles(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])newHash));
            }
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined((ModelNode)contentItemNode)) {
            if (this.contentRepository == null) {
                throw AbstractDeploymentHandler.createFailureException(DomainControllerLogger.ROOT_LOGGER.slaveCannotAcceptUploads());
            }
            try {
                newHash = DeploymentUploadUtil.storeContentAndTransformOperation(context, correctedOperation, this.contentRepository);
            }
            catch (IOException e) {
                throw AbstractDeploymentHandler.createFailureException(e.toString());
            }
            contentItemNode = new ModelNode();
            contentItemNode.get("hash").set(newHash);
            content = new ModelNode();
            content.add(contentItemNode);
        } else {
            newHash = null;
        }
        deploymentModel.get("runtime-name").set(runtimeName);
        deploymentModel.get("content").set(content);
        Resource root = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        if (root.hasChild(PathElement.pathElement((String)"server-group"))) {
            ModelNode enabled = correctedOperation.get(DeploymentAttributes.ENABLED.getName());
            for (Resource.ResourceEntry serverGroupResource : root.getChildren("server-group")) {
                Resource deploymentResource = serverGroupResource.getChild(deploymentPath);
                if (deploymentResource == null) continue;
                ModelNode groupDeploymentModel = deploymentResource.getModel();
                groupDeploymentModel.get("runtime-name").set(runtimeName);
                if (!enabled.isDefined()) continue;
                groupDeploymentModel.get(DeploymentAttributes.ENABLED.getName()).set(enabled);
            }
        }
        context.completeStep(new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    if (!(replacedHash == null || newHash != null && Arrays.equals(replacedHash, newHash))) {
                        ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)address, (byte[])replacedHash);
                        if (DeploymentFullReplaceHandler.this.contentRepository != null) {
                            DeploymentFullReplaceHandler.this.contentRepository.removeContent(reference);
                        } else {
                            DeploymentFullReplaceHandler.this.fileRepository.deleteDeployment(reference);
                        }
                    }
                    if (newHash != null && DeploymentFullReplaceHandler.this.contentRepository != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress((PathAddress)address, (byte[])newHash));
                    }
                } else if (!(newHash == null || replacedHash != null && Arrays.equals(replacedHash, newHash))) {
                    ContentReference reference = ModelContentReference.fromModelAddress((PathAddress)address, (byte[])newHash);
                    if (DeploymentFullReplaceHandler.this.contentRepository != null) {
                        DeploymentFullReplaceHandler.this.contentRepository.removeContent(reference);
                    } else {
                        DeploymentFullReplaceHandler.this.fileRepository.deleteDeployment(reference);
                    }
                }
            }
        });
    }
}

