/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso.elytron;

import io.undertow.server.session.SessionIdGenerator;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.sso.SSOManagerFactoryServiceConfiguratorProvider;
import org.wildfly.clustering.web.undertow.sso.SSOManagerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.elytron.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.elytron.ElytronAuthentication;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContext;
import org.wildfly.clustering.web.undertow.sso.elytron.LocalSSOContextFactory;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManagerServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Function<SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch>, SingleSignOnManager> {
    private final SupplierDependency<SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch>> manager;
    private final Collection<CapabilityServiceConfigurator> configurators;

    public DistributableSingleSignOnManagerServiceConfigurator(ServiceName name, String securityDomainName, SessionIdGenerator generator, SSOManagerFactoryServiceConfiguratorProvider provider) {
        super(name);
        CapabilityServiceConfigurator factoryConfigurator = provider.getServiceConfigurator(securityDomainName);
        ServiceSupplierDependency factoryDependency = new ServiceSupplierDependency((ServiceNameProvider)factoryConfigurator);
        SimpleSupplierDependency generatorDependency = new SimpleSupplierDependency((Object)generator);
        ServiceName managerServiceName = this.getServiceName().append(new String[]{"manager"});
        SSOManagerServiceConfigurator managerConfigurator = new SSOManagerServiceConfigurator(managerServiceName, factoryDependency, (SupplierDependency<SessionIdGenerator>)generatorDependency, new LocalSSOContextFactory());
        this.manager = new ServiceSupplierDependency(managerServiceName);
        this.configurators = Arrays.asList(factoryConfigurator, managerConfigurator);
    }

    @Override
    public SingleSignOnManager apply(SSOManager<ElytronAuthentication, String, Map.Entry<String, URI>, LocalSSOContext, Batch> manager) {
        return new DistributableSingleSignOnManager(manager);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        for (CapabilityServiceConfigurator configurator : this.configurators) {
            configurator.configure(support);
        }
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        for (CapabilityServiceConfigurator configurator : this.configurators) {
            configurator.build(target).install();
        }
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer manager = this.manager.register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(manager, (Function)this, this.manager);
        return builder.setInstance((Service)service);
    }
}

