/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import org.h2.message.Trace;
import org.h2.message.TraceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceWriterAdapter
implements TraceWriter {
    private String name;
    private final Logger logger = LoggerFactory.getLogger((String)"h2database");

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEnabled(int level) {
        switch (level) {
            case 3: {
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isInfoEnabled();
            }
            case 1: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void write(int level, int moduleId, String s, Throwable t) {
        this.write(level, Trace.MODULE_NAMES[moduleId], s, t);
    }

    @Override
    public void write(int level, String module, String s, Throwable t) {
        if (this.isEnabled(level)) {
            s = this.name != null ? this.name + ":" + module + " " + s : module + " " + s;
            switch (level) {
                case 3: {
                    this.logger.debug(s, t);
                    break;
                }
                case 2: {
                    this.logger.info(s, t);
                    break;
                }
                case 1: {
                    this.logger.error(s, t);
                    break;
                }
            }
        }
    }
}

