/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Random;

public class MathUtils {
    static SecureRandom cachedSecureRandom;
    static volatile boolean seeded;
    private static final Random RANDOM;

    private MathUtils() {
    }

    public static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    public static long roundUpLong(long x, long blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1L & -blockSizePowerOf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block10: {
            if (cachedSecureRandom != null) {
                return cachedSecureRandom;
            }
            try {
                cachedSecureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
                            byte[] seed = sr.generateSeed(20);
                            SecureRandom secureRandom = cachedSecureRandom;
                            synchronized (secureRandom) {
                                cachedSecureRandom.setSeed(seed);
                                seeded = true;
                            }
                        }
                        catch (Exception e) {
                            MathUtils.warn("SecureRandom", e);
                        }
                    }
                };
                try {
                    Thread t = new Thread(runnable, "Generate Seed");
                    t.setDaemon(true);
                    t.start();
                    Thread.yield();
                    try {
                        t.join(400L);
                    }
                    catch (InterruptedException e) {
                        MathUtils.warn("InterruptedException", e);
                    }
                    if (seeded) break block10;
                    byte[] seed = MathUtils.generateAlternativeSeed();
                    SecureRandom secureRandom = cachedSecureRandom;
                    synchronized (secureRandom) {
                        cachedSecureRandom.setSeed(seed);
                    }
                }
                catch (SecurityException e) {
                    runnable.run();
                    MathUtils.generateAlternativeSeed();
                }
            }
            catch (Exception e) {
                MathUtils.warn("SecureRandom", e);
                cachedSecureRandom = new SecureRandom();
            }
        }
        return cachedSecureRandom;
    }

    public static byte[] generateAlternativeSeed() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeLong(System.currentTimeMillis());
            out.writeLong(System.nanoTime());
            out.writeInt(new Object().hashCode());
            Runtime runtime = Runtime.getRuntime();
            out.writeLong(runtime.freeMemory());
            out.writeLong(runtime.maxMemory());
            out.writeLong(runtime.totalMemory());
            try {
                String s = System.getProperties().toString();
                out.writeInt(s.length());
                out.write(s.getBytes("UTF-8"));
            }
            catch (Exception e) {
                MathUtils.warn("generateAlternativeSeed", e);
            }
            try {
                Class<?> inetAddressClass = Class.forName("java.net.InetAddress");
                Object localHost = inetAddressClass.getMethod("getLocalHost", new Class[0]).invoke(null, new Object[0]);
                String hostName = inetAddressClass.getMethod("getHostName", new Class[0]).invoke(localHost, new Object[0]).toString();
                out.writeUTF(hostName);
                Object[] list = (Object[])inetAddressClass.getMethod("getAllByName", String.class).invoke(null, hostName);
                Method getAddress = inetAddressClass.getMethod("getAddress", new Class[0]);
                for (Object o : list) {
                    out.write((byte[])getAddress.invoke(o, new Object[0]));
                }
            }
            catch (Throwable inetAddressClass) {
                // empty catch block
            }
            for (int j = 0; j < 16; ++j) {
                int i = 0;
                long end = System.currentTimeMillis();
                while (end == System.currentTimeMillis()) {
                    ++i;
                }
                out.writeInt(i);
            }
            out.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            MathUtils.warn("generateAlternativeSeed", e);
            return new byte[1];
        }
    }

    static void warn(String s, Throwable t) {
        System.out.println("Warning: " + s);
        if (t != null) {
            t.printStackTrace();
        }
    }

    public static int nextPowerOf2(int x) {
        long i;
        for (i = 1L; i < (long)x && i < 0x3FFFFFFFL; i += i) {
        }
        return (int)i;
    }

    public static int convertLongToInt(long l) {
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static int compareInt(int a, int b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int compareLong(long a, long b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long secureRandomLong() {
        SecureRandom sr;
        SecureRandom secureRandom = sr = MathUtils.getSecureRandom();
        synchronized (secureRandom) {
            return sr.nextLong();
        }
    }

    public static void randomBytes(byte[] bytes) {
        RANDOM.nextBytes(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] secureRandomBytes(int len) {
        SecureRandom sr;
        if (len <= 0) {
            len = 1;
        }
        byte[] buff = new byte[len];
        SecureRandom secureRandom = sr = MathUtils.getSecureRandom();
        synchronized (secureRandom) {
            sr.nextBytes(buff);
        }
        return buff;
    }

    public static int randomInt(int lowerThan) {
        return RANDOM.nextInt(lowerThan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int secureRandomInt(int lowerThan) {
        SecureRandom sr;
        SecureRandom secureRandom = sr = MathUtils.getSecureRandom();
        synchronized (secureRandom) {
            return sr.nextInt(lowerThan);
        }
    }

    static {
        RANDOM = new Random();
    }
}

