/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.h2.message.DbException;
import org.h2.util.ToDateParser;

class ToDateTokenizer {
    static final Pattern PATTERN_NUMBER = Pattern.compile("^([+-]?[0-9]+)");
    static final Pattern PATTERN_FOUR_DIGITS = Pattern.compile("^([+-]?[0-9]{4})");
    static final Pattern PATTERN_TWO_TO_FOUR_DIGITS = Pattern.compile("^([+-]?[0-9]{2,4})");
    static final Pattern PATTERN_THREE_DIGITS = Pattern.compile("^([+-]?[0-9]{3})");
    static final Pattern PATTERN_TWO_DIGITS = Pattern.compile("^([+-]?[0-9]{2})");
    static final Pattern PATTERN_TWO_DIGITS_OR_LESS = Pattern.compile("^([+-]?[0-9][0-9]?)");
    static final Pattern PATTERN_ONE_DIGIT = Pattern.compile("^([+-]?[0-9])");
    static final Pattern PATTERN_FF = Pattern.compile("^(FF[0-9]?)", 2);
    static final Pattern PATTERN_AM_PM = Pattern.compile("^(AM|A\\.M\\.|PM|P\\.M\\.)", 2);
    static final Pattern PATTERN_BC_AD = Pattern.compile("^(BC|B\\.C\\.|AD|A\\.D\\.)", 2);
    static final YearParslet PARSLET_YEAR = new YearParslet();
    static final MonthParslet PARSLET_MONTH = new MonthParslet();
    static final DayParslet PARSLET_DAY = new DayParslet();
    static final TimeParslet PARSLET_TIME = new TimeParslet();
    static final int MILLIS_IN_HOUR = 3600000;

    ToDateTokenizer() {
    }

    static String matchStringOrThrow(Pattern p, ToDateParser params, Enum<?> aEnum) {
        String s = params.getInputStr();
        Matcher matcher = p.matcher(s);
        if (!matcher.find()) {
            ToDateTokenizer.throwException(params, String.format("Issue happened when parsing token '%s'", aEnum.name()));
        }
        return matcher.group(1);
    }

    static String setByName(Calendar c, ToDateParser params, int field, int style) {
        String inputFragmentStr = null;
        String s = params.getInputStr();
        Map<String, Integer> timeStringMap = c.getDisplayNames(field, style, Locale.getDefault());
        for (String dayName : timeStringMap.keySet()) {
            int len;
            if (!dayName.equalsIgnoreCase(s.substring(0, len = dayName.length()))) continue;
            c.set(field, timeStringMap.get(dayName));
            inputFragmentStr = dayName;
            break;
        }
        if (inputFragmentStr == null || inputFragmentStr.isEmpty()) {
            ToDateTokenizer.throwException(params, String.format("Tried to parse one of '%s' but failed (may be an internal error?)", timeStringMap.keySet()));
        }
        return inputFragmentStr;
    }

    static void throwException(ToDateParser params, String errorStr) {
        throw DbException.get(90056, params.getFunctionName(), String.format(" %s. Details: %s", errorStr, params));
    }

    public static enum FormatTokenEnum {
        YYYY(PARSLET_YEAR),
        SYYYY(PARSLET_YEAR),
        IYYY(PARSLET_YEAR),
        YYY(PARSLET_YEAR),
        IYY(PARSLET_YEAR),
        YY(PARSLET_YEAR),
        IY(PARSLET_YEAR),
        SCC(PARSLET_YEAR),
        CC(PARSLET_YEAR),
        RRRR(PARSLET_YEAR),
        RR(PARSLET_YEAR),
        BC_AD(PARSLET_YEAR, PATTERN_BC_AD),
        MONTH(PARSLET_MONTH),
        MON(PARSLET_MONTH),
        MM(PARSLET_MONTH),
        RM(PARSLET_MONTH),
        DDD(PARSLET_DAY),
        DAY(PARSLET_DAY),
        DD(PARSLET_DAY),
        DY(PARSLET_DAY),
        HH24(PARSLET_TIME),
        HH12(PARSLET_TIME),
        HH(PARSLET_TIME),
        MI(PARSLET_TIME),
        SSSSS(PARSLET_TIME),
        SS(PARSLET_TIME),
        FF(PARSLET_TIME, PATTERN_FF),
        TZH(PARSLET_TIME),
        TZM(PARSLET_TIME),
        TZR(PARSLET_TIME),
        TZD(PARSLET_TIME),
        AM_PM(PARSLET_TIME, PATTERN_AM_PM),
        EE(PARSLET_YEAR),
        E(PARSLET_YEAR),
        Y(PARSLET_YEAR),
        I(PARSLET_YEAR),
        Q(PARSLET_MONTH),
        D(PARSLET_DAY),
        J(PARSLET_DAY);

        private static final List<FormatTokenEnum> EMPTY_LIST;
        private static final Map<Character, List<FormatTokenEnum>> CACHE;
        private final ToDateParslet toDateParslet;
        private final Pattern patternToUse;

        private FormatTokenEnum(ToDateParslet toDateParslet, Pattern patternToUse) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = patternToUse;
        }

        private FormatTokenEnum(ToDateParslet toDateParslet) {
            this.toDateParslet = toDateParslet;
            this.patternToUse = Pattern.compile(String.format("^(%s)", this.name()), 2);
        }

        static List<FormatTokenEnum> getTokensInQuestion(String formatStr) {
            List<FormatTokenEnum> result = EMPTY_LIST;
            if (CACHE.size() <= 0) {
                FormatTokenEnum.initCache();
            }
            if (formatStr != null && formatStr.length() > 0) {
                Character key = Character.valueOf(Character.toUpperCase(formatStr.charAt(0)));
                result = CACHE.get(key);
            }
            if (result == null) {
                result = EMPTY_LIST;
            }
            return result;
        }

        private static synchronized void initCache() {
            if (CACHE.size() <= 0) {
                for (FormatTokenEnum token : FormatTokenEnum.values()) {
                    ArrayList<Character> tokenKeys = new ArrayList<Character>();
                    if (token.name().contains("_")) {
                        String[] tokens;
                        for (String tokenLets : tokens = token.name().split("_")) {
                            tokenKeys.add(Character.valueOf(tokenLets.toUpperCase().charAt(0)));
                        }
                    } else {
                        tokenKeys.add(Character.valueOf(token.name().toUpperCase().charAt(0)));
                    }
                    for (Character tokenKey : tokenKeys) {
                        List<FormatTokenEnum> l = CACHE.get(tokenKey);
                        if (l == null) {
                            l = new ArrayList<FormatTokenEnum>(1);
                            CACHE.put(tokenKey, l);
                        }
                        l.add(token);
                    }
                }
            }
        }

        boolean parseFormatStrWithToken(ToDateParser params) {
            Matcher matcher = this.patternToUse.matcher(params.getFormatStr());
            boolean foundToken = matcher.find();
            if (foundToken) {
                String formatTokenStr = matcher.group(1);
                this.toDateParslet.parse(params, this, formatTokenStr);
            }
            return foundToken;
        }

        static {
            EMPTY_LIST = new ArrayList<FormatTokenEnum>(0);
            CACHE = new HashMap<Character, List<FormatTokenEnum>>(FormatTokenEnum.values().length);
        }
    }

    static class TimeParslet
    implements ToDateParslet {
        TimeParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            Calendar result = params.getResultCalendar();
            String inputFragmentStr = null;
            int dateNr = 0;
            block0 : switch (formatTokenEnum) {
                case HH24: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(11, dateNr);
                    break;
                }
                case HH12: 
                case HH: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(10, dateNr);
                    break;
                }
                case MI: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(12, dateNr);
                    break;
                }
                case SS: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(13, dateNr);
                    break;
                }
                case SSSSS: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(11, 0);
                    result.set(12, 0);
                    result.set(13, dateNr);
                    break;
                }
                case FF: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    String paddedRightNrStr = String.format("%-9s", inputFragmentStr).replace(' ', '0');
                    paddedRightNrStr = paddedRightNrStr.substring(0, 9);
                    Double nineDigits = Double.parseDouble(paddedRightNrStr);
                    params.setNanos(nineDigits.intValue());
                    dateNr = (int)Math.round(nineDigits / 1000000.0);
                    result.set(14, dateNr);
                    break;
                }
                case AM_PM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_AM_PM, params, formatTokenEnum);
                    if (inputFragmentStr.toUpperCase().startsWith("A")) {
                        result.set(9, 0);
                        break;
                    }
                    result.set(9, 1);
                    break;
                }
                case TZH: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    TimeZone tz = result.getTimeZone();
                    int offsetMillis = tz.getRawOffset();
                    offsetMillis = offsetMillis / 3600000 * 3600000;
                    tz.setRawOffset(offsetMillis + dateNr);
                    result.setTimeZone(tz);
                    break;
                }
                case TZM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    TimeZone tz = result.getTimeZone();
                    int offsetMillis = tz.getRawOffset();
                    tz.setRawOffset(dateNr * 3600000 + (offsetMillis %= 3600000));
                    result.setTimeZone(tz);
                    break;
                }
                case TZR: {
                    String s = params.getInputStr();
                    TimeZone tz = result.getTimeZone();
                    for (String tzName : TimeZone.getAvailableIDs()) {
                        int length = tzName.length();
                        if (s.length() < length || !tzName.equalsIgnoreCase(s.substring(0, length))) continue;
                        tz.setID(tzName);
                        result.setTimeZone(tz);
                        inputFragmentStr = tzName;
                        break block0;
                    }
                    break;
                }
                case TZD: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class DayParslet
    implements ToDateParslet {
        DayParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            Calendar result = params.getResultCalendar();
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case DDD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(6, dateNr);
                    break;
                }
                case DD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(5, dateNr);
                    break;
                }
                case D: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(5, dateNr);
                    break;
                }
                case DAY: {
                    inputFragmentStr = ToDateTokenizer.setByName(result, params, 7, 2);
                    break;
                }
                case DY: {
                    inputFragmentStr = ToDateTokenizer.setByName(result, params, 7, 1);
                    break;
                }
                case J: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_NUMBER, params, formatTokenEnum);
                    try {
                        Date date = new SimpleDateFormat("Myydd").parse(inputFragmentStr);
                        result.setTime(date);
                    }
                    catch (ParseException e) {
                        ToDateTokenizer.throwException(params, String.format("Failed to parse Julian date: %s", inputFragmentStr));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class MonthParslet
    implements ToDateParslet {
        private static final String[] ROMAN_MONTH = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII"};

        MonthParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            Calendar result = params.getResultCalendar();
            String s = params.getInputStr();
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case MONTH: {
                    inputFragmentStr = ToDateTokenizer.setByName(result, params, 2, 2);
                    break;
                }
                case Q: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case MON: {
                    inputFragmentStr = ToDateTokenizer.setByName(result, params, 2, 1);
                    break;
                }
                case MM: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS_OR_LESS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(2, dateNr - 1);
                    break;
                }
                case RM: {
                    dateNr = 0;
                    for (String monthName : ROMAN_MONTH) {
                        ++dateNr;
                        int len = monthName.length();
                        if (s.length() < len || !monthName.equalsIgnoreCase(s.substring(0, len))) continue;
                        result.set(2, dateNr);
                        inputFragmentStr = monthName;
                        break;
                    }
                    if (inputFragmentStr != null && !inputFragmentStr.isEmpty()) break;
                    ToDateTokenizer.throwException(params, String.format("Issue happened when parsing token '%s'. Expected one of: %s", formatTokenEnum.name(), Arrays.toString(ROMAN_MONTH)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static class YearParslet
    implements ToDateParslet {
        YearParslet() {
        }

        @Override
        public void parse(ToDateParser params, FormatTokenEnum formatTokenEnum, String formatTokenStr) {
            Calendar result = params.getResultCalendar();
            String inputFragmentStr = null;
            int dateNr = 0;
            switch (formatTokenEnum) {
                case SYYYY: 
                case YYYY: 
                case IYYY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_FOUR_DIGITS, params, formatTokenEnum);
                    if (inputFragmentStr.startsWith("+")) {
                        inputFragmentStr = inputFragmentStr.substring(1);
                    }
                    if ((dateNr = Integer.parseInt(inputFragmentStr)) == 0) {
                        ToDateTokenizer.throwException(params, "Year may not be zero");
                    }
                    result.set(1, dateNr >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case YYY: 
                case IYY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_THREE_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(1, dateNr >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case RRRR: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_TO_FOUR_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    if (inputFragmentStr.length() < 4) {
                        if (dateNr < 50) {
                            dateNr += 2000;
                        } else if (dateNr < 100) {
                            dateNr += 1900;
                        }
                    }
                    if (dateNr == 0) {
                        ToDateTokenizer.throwException(params, "Year may not be zero");
                    }
                    result.set(1, dateNr);
                    break;
                }
                case RR: {
                    Calendar calendar = Calendar.getInstance();
                    int cc = calendar.get(1) / 100;
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr) + cc * 100;
                    result.set(1, dateNr);
                    break;
                }
                case EE: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case E: {
                    ToDateTokenizer.throwException(params, String.format("token '%s' not supported yet.", formatTokenEnum.name()));
                    break;
                }
                case YY: 
                case IY: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(1, dateNr >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case SCC: 
                case CC: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_TWO_DIGITS, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr) * 100;
                    result.set(1, dateNr);
                    break;
                }
                case Y: 
                case I: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_ONE_DIGIT, params, formatTokenEnum);
                    dateNr = Integer.parseInt(inputFragmentStr);
                    result.set(1, dateNr >= 0 ? dateNr : dateNr + 1);
                    break;
                }
                case BC_AD: {
                    inputFragmentStr = ToDateTokenizer.matchStringOrThrow(PATTERN_BC_AD, params, formatTokenEnum);
                    if (inputFragmentStr.toUpperCase().startsWith("B")) {
                        result.set(0, 0);
                        break;
                    }
                    result.set(0, 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s: Internal Error. Unhandled case: %s", new Object[]{this.getClass().getSimpleName(), formatTokenEnum}));
                }
            }
            params.remove(inputFragmentStr, formatTokenStr);
        }
    }

    static interface ToDateParslet {
        public void parse(ToDateParser var1, FormatTokenEnum var2, String var3);
    }
}

