/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.h2.api.TimestampWithTimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueTime;

public class ValueTimestampTimeZone
extends Value {
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    public static final int PRECISION = 30;
    static final int DISPLAY_SIZE = 30;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    private ValueTimestampTimeZone(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        if (timeZoneOffsetMins < -720 || timeZoneOffsetMins >= 720) {
            throw new IllegalArgumentException("timeZoneOffsetMins out of range " + timeZoneOffsetMins);
        }
        this.dateValue = dateValue;
        this.timeNanos = timeNanos;
        this.timeZoneOffsetMins = timeZoneOffsetMins;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long dateValue, long timeNanos, short timeZoneOffsetMins) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(dateValue, timeNanos, timeZoneOffsetMins));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestamp) {
        return ValueTimestampTimeZone.fromDateValueAndNanos(timestamp.getYMD(), timestamp.getNanosSinceMidnight(), timestamp.getTimeZoneOffsetMins());
    }

    public static ValueTimestampTimeZone parse(String s) {
        try {
            return ValueTimestampTimeZone.parseTry(s);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP WITH TIMEZONE", s);
        }
    }

    private static ValueTimestampTimeZone parseTry(String s) {
        long nanos;
        int timeStart;
        int dateEnd = s.indexOf(32);
        if (dateEnd < 0) {
            dateEnd = s.indexOf(84);
        }
        if (dateEnd < 0) {
            dateEnd = s.length();
            timeStart = -1;
        } else {
            timeStart = dateEnd + 1;
        }
        long dateValue = DateTimeUtils.parseDateValue(s, 0, dateEnd);
        short tzMinutes = 0;
        if (timeStart < 0) {
            nanos = 0L;
        } else {
            int timeEnd = s.length();
            if (s.endsWith("Z")) {
                --timeEnd;
            } else {
                String tzName;
                int timeZoneStart = s.indexOf(43, dateEnd);
                if (timeZoneStart < 0) {
                    timeZoneStart = s.indexOf(45, dateEnd);
                }
                TimeZone tz = null;
                if (timeZoneStart >= 0) {
                    tzName = "GMT" + s.substring(timeZoneStart);
                    tz = TimeZone.getTimeZone(tzName);
                    if (!tz.getID().startsWith(tzName)) {
                        throw new IllegalArgumentException(tzName + " (" + tz.getID() + "?)");
                    }
                    timeEnd = timeZoneStart;
                } else {
                    timeZoneStart = s.indexOf(32, dateEnd + 1);
                    if (timeZoneStart > 0) {
                        tzName = s.substring(timeZoneStart + 1);
                        tz = TimeZone.getTimeZone(tzName);
                        if (!tz.getID().startsWith(tzName)) {
                            throw new IllegalArgumentException(tzName);
                        }
                        timeEnd = timeZoneStart;
                    }
                }
                if (tz != null) {
                    long millis = DateTimeUtils.convertDateValueToMillis(GMT_TIMEZONE, dateValue);
                    tzMinutes = (short)(tz.getOffset(millis) / 1000 / 60);
                }
            }
            nanos = DateTimeUtils.parseTimeNanos(s, dateEnd + 1, timeEnd, true);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, nanos, tzMinutes);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    @Override
    public Timestamp getTimestamp() {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder(30);
        ValueDate.appendDate(buff, this.dateValue);
        buff.append(' ');
        ValueTime.appendTime(buff, this.timeNanos, true);
        ValueTimestampTimeZone.appendTimeZone(buff, this.timeZoneOffsetMins);
        return buff.toString();
    }

    private static void appendTimeZone(StringBuilder buff, short tz) {
        if (tz < 0) {
            buff.append('-');
            tz = -tz;
        } else {
            buff.append('+');
        }
        int hours = tz / 60;
        short mins = tz = (short)(tz - hours * 60);
        StringUtils.appendZeroPadded(buff, 2, hours);
        if (mins != 0) {
            buff.append(':');
            StringUtils.appendZeroPadded(buff, 2, mins);
        }
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP WITH TIMEZONE '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 30L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 30;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 10) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        long n = this.timeNanos;
        BigDecimal bd = BigDecimal.valueOf(n);
        bd = bd.movePointLeft(9);
        bd = ValueDecimal.setScale(bd, targetScale);
        long n2 = (bd = bd.movePointRight(9)).longValue();
        if (n2 == n) {
            return this;
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(this.dateValue, n2, this.timeZoneOffsetMins);
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueTimestampTimeZone t = (ValueTimestampTimeZone)o;
        long a = DateTimeUtils.convertDateValueToMillis(TimeZone.getTimeZone("UTC"), this.dateValue) / 60000L;
        long ma = this.timeNanos / 60000000000L;
        a += ma;
        long b = DateTimeUtils.convertDateValueToMillis(TimeZone.getTimeZone("UTC"), t.dateValue) / 60000L;
        long mb = t.timeNanos / 60000000000L;
        b += mb;
        int c = MathUtils.compareLong(a -= (long)this.timeZoneOffsetMins, b -= (long)t.timeZoneOffsetMins);
        if (c != 0) {
            return c;
        }
        long na = this.timeNanos - ma * 1000L * 1000L * 1000L * 60L;
        long nb = t.timeNanos - mb * 1000L * 1000L * 1000L * 60L;
        return MathUtils.compareLong(na, nb);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone x = (ValueTimestampTimeZone)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos && this.timeZoneOffsetMins == x.timeZoneOffsetMins;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetMins);
    }

    @Override
    public Object getObject() {
        return new TimestampWithTimeZone(this.dateValue, this.timeNanos, this.timeZoneOffsetMins);
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.getString());
    }

    @Override
    public Value add(Value v) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }

    @Override
    public Value subtract(Value v) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }
}

