/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command;

import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandException;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.Executor;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.readline.AeshContext;
import org.aesh.readline.util.Parser;

public interface CommandRuntime<C extends Command<CI>, CI extends CommandInvocation> {
    public CommandRegistry<C, CI> getCommandRegistry();

    public Executor<CI> buildExecutor(String var1) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, IOException;

    public void executeCommand(String var1) throws CommandNotFoundException, CommandLineParserException, OptionValidatorException, CommandValidatorException, CommandException, InterruptedException, IOException;

    public AeshContext getAeshContext();

    default public String commandInfo(String line) {
        try {
            String name = Parser.findFirstWord((String)line);
            return this.getCommandRegistry().getCommand(name, line).printHelp(name);
        }
        catch (CommandNotFoundException e) {
            return null;
        }
    }

    public CommandInvocationBuilder<C, CI> commandInvocationBuilder();

    public void complete(AeshCompleteOperation var1);
}

