/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import java.io.Console;
import java.io.IOError;
import java.util.IllegalFormatException;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.logger.ServerMigrationLogger;

public class JavaConsole
implements ConsoleWrapper {
    private Console theConsole = System.console();

    @Override
    public void format(String fmt, Object ... args) throws IllegalFormatException {
        if (this.hasConsole()) {
            this.theConsole.format(fmt, args);
        } else {
            System.out.format(fmt, args);
        }
    }

    @Override
    public void printf(String format, Object ... args) throws IllegalFormatException {
        if (this.hasConsole()) {
            this.theConsole.printf(format, args);
        } else {
            System.out.format(format, args);
        }
    }

    @Override
    public String readLine(String fmt, Object ... args) throws IOError {
        if (this.hasConsole()) {
            return this.theConsole.readLine(fmt, args);
        }
        throw ServerMigrationLogger.ROOT_LOGGER.noConsoleAvailable();
    }

    @Override
    public char[] readPassword(String fmt, Object ... args) throws IllegalFormatException, IOError {
        if (this.hasConsole()) {
            return this.theConsole.readPassword(fmt, args);
        }
        throw ServerMigrationLogger.ROOT_LOGGER.noConsoleAvailable();
    }

    @Override
    public boolean hasConsole() {
        return this.theConsole != null;
    }
}

