/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.nio;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.activemq.artemis.core.io.AbstractSequentialFileFactory;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFile;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory {
    private static final int DEFAULT_CAPACITY_ALIGNMENT = Env.osPageSize();
    private boolean bufferPooling = true;
    private final ThreadLocal<ByteBuffer> bytesPool = new ThreadLocal();

    public NIOSequentialFileFactory(File journalDir, int maxIO) {
        this(journalDir, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, false, 501760, 3333333, maxIO, false, listener, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int maxIO) {
        this(journalDir, buffered, null, maxIO);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, IOCriticalErrorListener listener, int maxIO) {
        this(journalDir, buffered, 501760, 3333333, maxIO, false, listener, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates) {
        this(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, null, null);
    }

    public NIOSequentialFileFactory(File journalDir, boolean buffered, int bufferSize, int bufferTimeout, int maxIO, boolean logRates, IOCriticalErrorListener listener, CriticalAnalyzer analyzer) {
        super(journalDir, buffered, bufferSize, bufferTimeout, maxIO, logRates, listener, analyzer);
    }

    public static ByteBuffer allocateDirectByteBuffer(int size) {
        ByteBuffer buffer2 = null;
        try {
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError error) {
            WeakReference<Object> obj = new WeakReference<Object>(new Object());
            try {
                long timeout = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() > timeout && obj.get() != null) {
                    System.gc();
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            buffer2 = ByteBuffer.allocateDirect(size);
        }
        return buffer2;
    }

    public void enableBufferReuse() {
        this.bufferPooling = true;
    }

    public void disableBufferReuse() {
        this.bufferPooling = false;
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        return new NIOSequentialFile(this, this.journalDir, fileName, this.maxIO, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    private static int align(int value, int pow2alignment) {
        return value + (pow2alignment - 1) & ~(pow2alignment - 1);
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int requiredCapacity = NIOSequentialFileFactory.align(size, DEFAULT_CAPACITY_ALIGNMENT);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (!this.bufferPooling) {
            return this.allocateDirectBuffer(size);
        }
        int requiredCapacity = NIOSequentialFileFactory.align(size, DEFAULT_CAPACITY_ALIGNMENT);
        ByteBuffer byteBuffer = this.bytesPool.get();
        if (byteBuffer == null || requiredCapacity > byteBuffer.capacity()) {
            byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        } else {
            this.bytesPool.set(null);
            PlatformDependent.setMemory((long)PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer), (long)size, (byte)0);
            byteBuffer.clear();
        }
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (this.bufferPooling && buffer.isDirect() && (byteBuffer = this.bytesPool.get()) != buffer) {
            if (byteBuffer == null || buffer.capacity() > byteBuffer.capacity()) {
                if (byteBuffer != null) {
                    PlatformDependent.freeDirectBuffer((ByteBuffer)byteBuffer);
                }
                this.bytesPool.set(buffer);
            } else {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        }
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            PlatformDependent.setMemory((long)PlatformDependent.directBufferAddress((ByteBuffer)buffer), (long)buffer.limit(), (byte)0);
        } else {
            Arrays.fill(buffer.array(), buffer.arrayOffset(), buffer.limit(), (byte)0);
        }
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

