/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.cursor.LivePageCache;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscriptionCounter;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.Env;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.jboss.logging.Logger;

public final class Page
implements Comparable<Page> {
    private static final Logger logger = Logger.getLogger(Page.class);
    public static final int SIZE_RECORD = 6;
    private static final byte START_BYTE = 123;
    private static final byte END_BYTE = 125;
    private final int pageId;
    private boolean suspiciousRecords = false;
    private final AtomicInteger numberOfMessages = new AtomicInteger(0);
    private final SequentialFile file;
    private final SequentialFileFactory fileFactory;
    private volatile LivePageCache pageCache;
    private final AtomicInteger size = new AtomicInteger(0);
    private final StorageManager storageManager;
    private final SimpleString storeName;
    private Set<PageSubscriptionCounter> pendingCounters;
    private static final int HEADER_AND_TRAILER_SIZE = 6;
    private static final int MINIMUM_MSG_PERSISTENT_SIZE = 6;
    private static final int MIN_CHUNK_SIZE = Env.osPageSize();

    public Page(SimpleString storeName, StorageManager storageManager, SequentialFileFactory factory, SequentialFile file, int pageId) throws Exception {
        this.pageId = pageId;
        this.file = file;
        this.fileFactory = factory;
        this.storageManager = storageManager;
        this.storeName = storeName;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setLiveCache(LivePageCache pageCache) {
        this.pageCache = pageCache;
    }

    public LivePageCache getLiveCache() {
        return this.pageCache;
    }

    public synchronized List<PagedMessage> read(StorageManager storage) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("reading page " + this.pageId + " on address = " + this.storeName));
        }
        if (!this.file.isOpen()) {
            throw ActiveMQMessageBundle.BUNDLE.invalidPageIO();
        }
        this.size.lazySet((int)this.file.size());
        List<PagedMessage> messages = this.readFromSequentialFile(storage);
        this.numberOfMessages.lazySet(messages.size());
        return messages;
    }

    private ByteBuffer allocateAndReadIntoFileBuffer(ByteBuffer fileBuffer, int requiredBytes) throws Exception {
        ByteBuffer newFileBuffer = this.fileFactory.newBuffer(Math.max(requiredBytes, MIN_CHUNK_SIZE));
        newFileBuffer.put(fileBuffer);
        this.fileFactory.releaseBuffer(fileBuffer);
        fileBuffer = newFileBuffer;
        fileBuffer.limit(fileBuffer.capacity());
        this.file.read(fileBuffer);
        fileBuffer.position(0);
        return fileBuffer;
    }

    private ByteBuffer readIntoFileBufferIfNecessary(ByteBuffer fileBuffer, int requiredBytes) throws Exception {
        int remaining = fileBuffer.remaining();
        int bytesToBeRead = requiredBytes - remaining;
        if (bytesToBeRead > 0) {
            int capacity = fileBuffer.capacity();
            if (capacity >= requiredBytes) {
                if (fileBuffer.limit() > 0) {
                    fileBuffer.compact();
                } else {
                    fileBuffer.limit(capacity);
                }
                this.file.read(fileBuffer);
                fileBuffer.position(0);
            } else {
                fileBuffer = this.allocateAndReadIntoFileBuffer(fileBuffer, requiredBytes);
            }
        }
        return fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChannelBufferWrapper wrapWhole(ByteBuffer fileBuffer) {
        int position = fileBuffer.position();
        int limit = fileBuffer.limit();
        int capacity = fileBuffer.capacity();
        try {
            ChannelBufferWrapper fileBufferWrapper;
            fileBuffer.clear();
            ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((ByteBuffer)fileBuffer);
            assert (wrappedBuffer.readableBytes() == capacity);
            ChannelBufferWrapper channelBufferWrapper = fileBufferWrapper = new ChannelBufferWrapper(wrappedBuffer);
            return channelBufferWrapper;
        }
        finally {
            fileBuffer.position(position);
            fileBuffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<PagedMessage> readFromSequentialFile(StorageManager storage) throws Exception {
        block22: {
            block21: {
                block20: {
                    block19: {
                        messages = new ArrayList<PagedMessage>();
                        fileSize = (int)this.file.size();
                        this.file.position(0L);
                        processedBytes = 0;
                        fileBuffer = null;
                        try {
                            remainingBytes = fileSize - processedBytes;
                            if (remainingBytes < 6) ** GOTO lbl77
                            fileBuffer = this.fileFactory.newBuffer(Math.min(remainingBytes, Page.MIN_CHUNK_SIZE));
                            fileBufferWrapper = Page.wrapWhole(fileBuffer);
                            fileBuffer.limit(0);
                            while (true) {
                                oldFileBuffer = fileBuffer;
                                if ((fileBuffer = this.readIntoFileBufferIfNecessary(fileBuffer, 6)) != oldFileBuffer) {
                                    fileBufferWrapper = Page.wrapWhole(fileBuffer);
                                }
                                if ((startByte = fileBuffer.get()) != 123) ** GOTO lbl-1000
                                encodedSize = fileBuffer.getInt();
                                nextPosition = processedBytes + 6 + encodedSize;
                                if (nextPosition <= fileSize) {
                                    currentFileBuffer = fileBuffer;
                                    if ((fileBuffer = this.readIntoFileBufferIfNecessary(fileBuffer, encodedSize + 1)) != currentFileBuffer) {
                                        fileBufferWrapper = Page.wrapWhole(fileBuffer);
                                    }
                                    endPosition = fileBuffer.position() + encodedSize;
                                    if (fileBuffer.remaining() >= encodedSize + 1 && fileBuffer.get(endPosition) == 125) {
                                        msg = new PagedMessageImpl(this.storageManager);
                                        fileBufferWrapper.setIndex(fileBuffer.position(), endPosition);
                                        msg.decode((ActiveMQBuffer)fileBufferWrapper);
                                        fileBuffer.position(endPosition + 1);
                                        if (!Page.$assertionsDisabled && fileBuffer.get(endPosition) != 125) {
                                            throw new AssertionError((Object)"decoding cannot change end byte");
                                        }
                                        msg.initMessage(storage);
                                        if (Page.logger.isTraceEnabled()) {
                                            Page.logger.tracef("Reading message %s on pageId=%d for address=%s", (Object)msg, (Object)this.pageId, (Object)this.storeName);
                                        }
                                        messages.add(msg);
                                        processedBytes = nextPosition;
                                        continue;
                                    }
                                    this.markFileAsSuspect(this.file.getFileName(), processedBytes, messages.size());
                                    var14_15 = messages;
                                    if (fileBuffer == null) break block19;
                                }
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        catch (Throwable var15_16) {
                            if (fileBuffer != null) {
                                this.fileFactory.releaseBuffer(fileBuffer);
                            }
                            this.size.lazySet(processedBytes);
                            if (this.file.position() != (long)processedBytes) {
                                this.file.position((long)processedBytes);
                            }
                            throw var15_16;
                        }
                        this.fileFactory.releaseBuffer(fileBuffer);
                    }
                    this.size.lazySet(processedBytes);
                    if (this.file.position() != (long)processedBytes) {
                        this.file.position((long)processedBytes);
                    }
                    return var14_15;
lbl-1000:
                    // 1 sources

                    {
                        this.markFileAsSuspect(this.file.getFileName(), processedBytes, messages.size());
                        var12_13 = messages;
                        if (fileBuffer == null) break block20;
                    }
                    this.fileFactory.releaseBuffer(fileBuffer);
                }
                this.size.lazySet(processedBytes);
                if (this.file.position() != (long)processedBytes) {
                    this.file.position((long)processedBytes);
                }
                return var12_13;
lbl-1000:
                // 1 sources

                {
                    this.markFileAsSuspect(this.file.getFileName(), processedBytes, messages.size());
                    var10_11 = messages;
                    if (fileBuffer == null) break block21;
                }
                this.fileFactory.releaseBuffer(fileBuffer);
            }
            this.size.lazySet(processedBytes);
            if (this.file.position() != (long)processedBytes) {
                this.file.position((long)processedBytes);
            }
            return var10_11;
            {
                if ((remainingBytes = fileSize - processedBytes) >= 6) ** continue;
lbl77:
                // 2 sources

                if (Page.logger.isTraceEnabled()) {
                    Page.logger.tracef("%s has %d bytes of unknown data at position = %d", (Object)this.file.getFileName(), (Object)remainingBytes, (Object)processedBytes);
                }
                var8_8 = messages;
                if (fileBuffer == null) break block22;
            }
            this.fileFactory.releaseBuffer(fileBuffer);
        }
        this.size.lazySet(processedBytes);
        if (this.file.position() != (long)processedBytes) {
            this.file.position((long)processedBytes);
        }
        return var8_8;
    }

    public synchronized void write(PagedMessage message) throws Exception {
        if (!this.file.isOpen()) {
            throw ActiveMQMessageBundle.BUNDLE.cannotWriteToClosedFile(this.file);
        }
        int messageEncodedSize = message.getEncodeSize();
        int bufferSize = messageEncodedSize + 6;
        ByteBuffer buffer = this.fileFactory.newBuffer(bufferSize);
        ChannelBufferWrapper activeMQBuffer = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)buffer));
        activeMQBuffer.clear();
        activeMQBuffer.writeByte((byte)123);
        activeMQBuffer.writeInt(messageEncodedSize);
        message.encode((ActiveMQBuffer)activeMQBuffer);
        activeMQBuffer.writeByte((byte)125);
        assert (activeMQBuffer.readableBytes() == bufferSize) : "messageEncodedSize is different from expected";
        assert (buffer.remaining() == bufferSize) : "buffer position or limit are changed";
        this.file.writeDirect(buffer, false);
        if (this.pageCache != null) {
            this.pageCache.addLiveMessage(message);
        }
        this.numberOfMessages.lazySet(this.numberOfMessages.get() + 1);
        this.size.lazySet(this.size.get() + bufferSize);
        this.storageManager.pageWrite(message, this.pageId);
    }

    public void sync() throws Exception {
        this.file.sync();
    }

    public void open() throws Exception {
        if (!this.file.isOpen()) {
            this.file.open();
        }
        this.size.set((int)this.file.size());
        this.file.position(0L);
    }

    public void close(boolean sendEvent) throws Exception {
        this.close(sendEvent, true);
    }

    public synchronized void close(boolean sendEvent, boolean waitSync) throws Exception {
        if (sendEvent && this.storageManager != null) {
            this.storageManager.pageClosed(this.storeName, this.pageId);
        }
        if (this.pageCache != null) {
            this.pageCache.close();
            this.pageCache = null;
        }
        this.file.close(waitSync);
        Set<PageSubscriptionCounter> counters = this.getPendingCounters();
        if (counters != null) {
            for (PageSubscriptionCounter counter : counters) {
                counter.cleanupNonTXCounters(this.getPageId());
            }
        }
    }

    public boolean isLive() {
        return this.pageCache != null;
    }

    public boolean delete(PagedMessage[] messages) throws Exception {
        if (this.storageManager != null) {
            this.storageManager.pageDeleted(this.storeName, this.pageId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting pageNr=" + this.pageId + " on store " + this.storeName));
        }
        if (messages != null) {
            for (PagedMessage msg : messages) {
                if (!(msg.getMessage() instanceof ICoreMessage) || !msg.getMessage().isLargeMessage()) continue;
                LargeServerMessage lmsg = (LargeServerMessage)msg.getMessage();
                lmsg.decrementDelayDeletionCount();
            }
        }
        try {
            if (this.suspiciousRecords) {
                ActiveMQServerLogger.LOGGER.pageInvalid(this.file.getFileName(), this.file.getFileName());
                this.file.renameTo(this.file.getFileName() + ".invalidPage");
            } else {
                this.file.delete();
            }
            return true;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.pageDeleteError(e);
            return false;
        }
    }

    public int getNumberOfMessages() {
        return this.numberOfMessages.intValue();
    }

    public int getSize() {
        return this.size.intValue();
    }

    public String toString() {
        return "Page::pageNr=" + this.pageId + ", file=" + this.file;
    }

    @Override
    public int compareTo(Page otherPage) {
        return otherPage.getPageId() - this.pageId;
    }

    protected void finalize() {
        try {
            if (this.file != null && this.file.isOpen()) {
                this.file.close(false);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.pageFinaliseError(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.pageId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Page other = (Page)obj;
        return this.pageId == other.pageId;
    }

    private void markFileAsSuspect(String fileName, int position, int msgNumber) {
        ActiveMQServerLogger.LOGGER.pageSuspectFile(fileName, position, msgNumber);
        this.suspiciousRecords = true;
    }

    public SequentialFile getFile() {
        return this.file;
    }

    public void addPendingCounter(PageSubscriptionCounter pageSubscriptionCounter) {
        this.getOrCreatePendingCounters().add(pageSubscriptionCounter);
    }

    private synchronized Set<PageSubscriptionCounter> getPendingCounters() {
        return this.pendingCounters;
    }

    private synchronized Set<PageSubscriptionCounter> getOrCreatePendingCounters() {
        if (this.pendingCounters == null) {
            this.pendingCounters = new ConcurrentHashSet();
        }
        return this.pendingCounters;
    }
}

