/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.naming.deployment.RuntimeBindReleaseService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JndiNamingDependencyProcessor
implements DeploymentUnitProcessor {
    private static final ServiceName JNDI_DEPENDENCY_SERVICE = ServiceName.of((String[])new String[]{"jndiDependencyService"});
    private static final String JNDI_AGGREGATION_SERVICE_SUFFIX = "componentJndiDependencies";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        ServiceName namingStoreServiceName = support.getCapabilityServiceName("org.wildfly.naming");
        phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, (Object)namingStoreServiceName);
        ServiceName serviceName = JndiNamingDependencyProcessor.serviceName(deploymentUnit.getServiceName());
        ServiceBuilder serviceBuilder = phaseContext.getServiceTarget().addService(serviceName, (Service)new RuntimeBindReleaseService());
        JndiNamingDependencyProcessor.addAllDependencies(serviceBuilder, deploymentUnit.getAttachmentList(Attachments.JNDI_DEPENDENCIES));
        Map compJndiDeps = (Map)deploymentUnit.getAttachment(Attachments.COMPONENT_JNDI_DEPENDENCIES);
        Set<ServiceName> aggregatingServices = JndiNamingDependencyProcessor.installComponentJndiAggregatingServices(phaseContext.getServiceTarget(), compJndiDeps);
        JndiNamingDependencyProcessor.addAllDependencies(serviceBuilder, aggregatingServices);
        if (deploymentUnit.getParent() != null) {
            JndiNamingDependencyProcessor.addAllDependencies(serviceBuilder, (Collection)deploymentUnit.getParent().getAttachment(Attachments.JNDI_DEPENDENCIES));
            compJndiDeps = (Map)deploymentUnit.getParent().getAttachment(Attachments.COMPONENT_JNDI_DEPENDENCIES);
            aggregatingServices = JndiNamingDependencyProcessor.installComponentJndiAggregatingServices(phaseContext.getServiceTarget(), compJndiDeps);
            JndiNamingDependencyProcessor.addAllDependencies(serviceBuilder, aggregatingServices);
        }
        serviceBuilder.addDependency(namingStoreServiceName);
        serviceBuilder.install();
    }

    private static Set<ServiceName> installComponentJndiAggregatingServices(ServiceTarget target, Map<ServiceName, Set<ServiceName>> mappings) {
        if (mappings == null) {
            return Collections.emptySet();
        }
        HashSet<ServiceName> retVal = new HashSet<ServiceName>();
        for (Map.Entry<ServiceName, Set<ServiceName>> mapping : mappings.entrySet()) {
            ServiceName sn = mapping.getKey().append(new String[]{JNDI_AGGREGATION_SERVICE_SUFFIX});
            retVal.add(sn);
            ServiceBuilder sb = target.addService(sn);
            for (ServiceName depName : mapping.getValue()) {
                sb.requires(depName);
            }
            sb.install();
        }
        return retVal;
    }

    private static void addAllDependencies(ServiceBuilder sb, Collection<ServiceName> dependencies) {
        for (ServiceName dependency : dependencies) {
            sb.requires(dependency);
        }
    }

    public static ServiceName serviceName(ServiceName deploymentUnitServiceName) {
        return deploymentUnitServiceName.append(JNDI_DEPENDENCY_SERVICE);
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return JndiNamingDependencyProcessor.serviceName(deploymentUnit.getServiceName());
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.JNDI_DEPENDENCIES);
    }
}

