/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.infinispan.InfinispanXAResourceRecovery;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.SimpleServiceNameProvider;

public class XAResourceRecoveryServiceConfigurator
extends SimpleServiceNameProvider
implements ServiceConfigurator,
Supplier<XAResourceRecovery>,
Consumer<XAResourceRecovery> {
    private volatile Supplier<Cache<?, ?>> cache;
    private volatile Supplier<XAResourceRecoveryRegistry> registry;

    public XAResourceRecoveryServiceConfigurator(PathAddress cacheAddress) {
        super(CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress).append(new String[]{"recovery"}));
    }

    @Override
    public XAResourceRecovery get() {
        Cache<?, ?> cache = this.cache.get();
        InfinispanXAResourceRecovery recovery = new InfinispanXAResourceRecovery(cache);
        if (cache.getCacheConfiguration().transaction().recovery().enabled()) {
            this.registry.get().addXAResourceRecovery((XAResourceRecovery)recovery);
        }
        return recovery;
    }

    @Override
    public void accept(XAResourceRecovery recovery) {
        if (this.cache.get().getCacheConfiguration().transaction().recovery().enabled()) {
            this.registry.get().removeXAResourceRecovery(recovery);
        }
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        this.cache = builder.requires(this.getServiceName().getParent());
        this.registry = builder.requires(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER);
        Consumer recovery = builder.provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(recovery, Function.identity(), (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.PASSIVE);
    }
}

