/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential.source;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.source.CredentialSource;

public class FactoryCredentialSource
implements CredentialSource {
    private SecurityFactory<? extends Credential> credentialFactory;

    public FactoryCredentialSource(SecurityFactory<? extends Credential> credentialFactory) {
        Assert.checkNotNullParam((String)"credentialFactory", credentialFactory);
        this.credentialFactory = credentialFactory;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        return this.getCredential(credentialType, algorithmName, parameterSpec) != null ? SupportLevel.SUPPORTED : SupportLevel.UNSUPPORTED;
    }

    @Override
    public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws IOException {
        try {
            return this.credentialFactory.create().castAs(credentialType, algorithmName, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.unableToReadCredential(e);
        }
    }
}

