/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.Collection;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.suspend.SuspendController;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RequestControllerDeploymentUnitProcessor;
import org.wildfly.extension.requestcontroller.RequestControllerRootDefinition;

class RequestControllerSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    RequestControllerSubsystemAdd(Collection<AttributeDefinition> attributeDefinitions) {
        super(RequestControllerRootDefinition.REQUEST_CONTROLLER_CAPABILITY, attributeDefinitions);
    }

    public void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                processorTarget.addDeploymentProcessor("request-controller", Phase.STRUCTURE, 8192, (DeploymentUnitProcessor)new RequestControllerDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        int maxRequests = RequestControllerRootDefinition.MAX_REQUESTS.resolveModelAttribute(context, resource.getModel()).asInt();
        boolean trackIndividual = RequestControllerRootDefinition.TRACK_INDIVIDUAL_ENDPOINTS.resolveModelAttribute(context, resource.getModel()).asBoolean();
        RequestController requestController = new RequestController(trackIndividual);
        requestController.setMaxRequestCount(maxRequests);
        context.getServiceTarget().addService(RequestController.SERVICE_NAME, (Service)requestController).addDependency(SuspendController.SERVICE_NAME, SuspendController.class, requestController.getShutdownControllerInjectedValue()).install();
    }
}

