/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.Unmarshaller;

public final class UnmarshallingObjectInputStream
extends ObjectInputStream {
    private Unmarshaller unmarshaller;

    public UnmarshallingObjectInputStream(Unmarshaller unmarshaller, InputStream stream) throws IOException, SecurityException {
        this(unmarshaller, Marshalling.createByteInput(stream));
    }

    public UnmarshallingObjectInputStream(Unmarshaller unmarshaller, ByteInput byteInput) throws IOException, SecurityException {
        unmarshaller.start(byteInput);
        this.unmarshaller = unmarshaller;
    }

    @Override
    public Object readUnshared() throws IOException, ClassNotFoundException {
        return this.unmarshaller.readObjectUnshared();
    }

    @Override
    protected Object readObjectOverride() throws ClassNotFoundException, IOException {
        return this.unmarshaller.readObject();
    }

    @Override
    public int read() throws IOException {
        return this.unmarshaller.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.unmarshaller.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.unmarshaller.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.unmarshaller.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.unmarshaller.available();
    }

    @Override
    public void close() throws IOException, IllegalStateException {
        this.unmarshaller.finish();
        this.unmarshaller = null;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.unmarshaller.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.unmarshaller.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.unmarshaller.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.unmarshaller.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.unmarshaller.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.unmarshaller.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.unmarshaller.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.unmarshaller.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        return this.unmarshaller.readChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.unmarshaller.readInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.unmarshaller.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.unmarshaller.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.unmarshaller.readDouble();
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.unmarshaller.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.unmarshaller.readUTF();
    }

    public Object readObjectUnshared() throws ClassNotFoundException, IOException {
        return this.unmarshaller.readObjectUnshared();
    }

    @Override
    protected final Class<?> resolveClass(ObjectStreamClass desc) throws IllegalStateException {
        throw new IllegalStateException("Class may not be resolved in this context");
    }

    @Override
    protected final Class<?> resolveProxyClass(String[] interfaces) throws IllegalStateException {
        throw new IllegalStateException("Class may not be resolved in this context");
    }

    @Override
    protected final Object resolveObject(Object obj) throws IllegalStateException {
        throw new IllegalStateException("Object may not be resolved in this context");
    }

    @Override
    protected final boolean enableResolveObject(boolean enable) throws IllegalStateException {
        throw new IllegalStateException("Object resolution may not be enabled in this context");
    }

    @Override
    protected final void readStreamHeader() throws IllegalStateException {
        throw new IllegalStateException("Stream header may not be read in this context");
    }

    @Override
    protected final ObjectStreamClass readClassDescriptor() throws IllegalStateException {
        throw new IllegalStateException("Class descriptor may not be read in this context");
    }

    @Override
    public void defaultReadObject() throws IllegalStateException {
        throw new IllegalStateException("This method may not be invoked in this context");
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IllegalStateException {
        throw new IllegalStateException("Fields may not be read in this context");
    }

    @Override
    public void registerValidation(ObjectInputValidation obj, int prio) throws IllegalStateException {
        throw new IllegalStateException("Validation objects may not be registered in this context");
    }
}

