/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.remoting.transport.Address;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.clustering.spi.NodeFactory;
import org.wildfly.clustering.web.infinispan.session.InfinispanRouteLocatorConfiguration;
import org.wildfly.clustering.web.session.RouteLocator;

public class InfinispanRouteLocator
implements RouteLocator {
    private final NodeFactory<Address> factory;
    private final Registry<String, Void> registry;
    private final Cache<Key<String>, ?> cache;
    private final boolean preferPrimary;

    public InfinispanRouteLocator(InfinispanRouteLocatorConfiguration config) {
        this.cache = config.getCache();
        this.registry = config.getRegistry();
        this.factory = config.getMemberFactory();
        CacheMode mode = this.cache.getCacheConfiguration().clustering().cacheMode();
        this.preferPrimary = mode.needsStateTransfer() && !mode.isScattered();
    }

    public String locate(String sessionId) {
        Map.Entry entry;
        Address address = this.preferPrimary ? this.cache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)new Key((Object)sessionId)).primary() : this.cache.getCacheManager().getAddress();
        Node node = address != null ? this.factory.createNode((Object)address) : null;
        Map.Entry entry2 = entry = node != null ? this.registry.getEntry(node) : null;
        if (entry == null) {
            entry = this.registry.getEntry(this.registry.getGroup().getLocalMember());
        }
        return entry != null ? (String)entry.getKey() : null;
    }
}

