/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import org.infinispan.Cache;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.MutatorFactory;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.ee.infinispan.InfinispanCacheProperties;

public class InfinispanMutatorFactory<K, V>
implements MutatorFactory<K, V> {
    private final Cache<K, V> cache;
    private final CacheProperties properties;

    public InfinispanMutatorFactory(Cache<K, V> cache) {
        this(cache, new InfinispanCacheProperties(cache.getCacheConfiguration()));
    }

    public InfinispanMutatorFactory(Cache<K, V> cache, CacheProperties properties) {
        this.cache = cache;
        this.properties = properties;
    }

    public Mutator createMutator(K key, V value) {
        return this.properties.isPersistent() ? new CacheEntryMutator<K, V>(this.cache, key, value) : Mutator.PASSIVE;
    }
}

