/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.AbstractArtemisActionHandler;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.TemporaryFileInputStream;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class PrintDataOperation
extends AbstractArtemisActionHandler {
    public static final String OPERATION_NAME = "print-data";
    static final PrintDataOperation INSTANCE = new PrintDataOperation();
    private static final AttributeDefinition REPLY_UUID = new SimpleAttributeDefinitionBuilder("uuid", ModelType.STRING, false).build();
    private static final AttributeDefinition PARAM_SECRET = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secret", ModelType.BOOLEAN, false).setDefaultValue(ModelNode.TRUE)).build();
    private static final AttributeDefinition PARAM_ARCHIVE = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("archive", ModelType.BOOLEAN, false).setDefaultValue(ModelNode.FALSE)).build();

    private PrintDataOperation() {
    }

    void registerOperation(ManagementResourceRegistration registry, ResourceDescriptionResolver resourceDescriptionResolver) {
        registry.registerOperationHandler((OperationDefinition)new SimpleOperationDefinitionBuilder(OPERATION_NAME, resourceDescriptionResolver).addParameter(PARAM_SECRET).addParameter(PARAM_ARCHIVE).setReplyParameters(new AttributeDefinition[]{REPLY_UUID}).setRuntimeOnly().build(), (OperationStepHandler)INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) {
            throw MessagingLogger.ROOT_LOGGER.managementOperationAllowedOnlyInRunningMode(OPERATION_NAME, RunningMode.ADMIN_ONLY);
        }
        this.checkAllowedOnJournal(context, OPERATION_NAME);
        boolean secret = PARAM_SECRET.resolveModelAttribute(context, operation).asBoolean();
        boolean archive = PARAM_ARCHIVE.resolveModelAttribute(context, operation).asBoolean();
        File bindings = this.resolveFile(context, MessagingExtension.BINDINGS_DIRECTORY_PATH);
        File paging = this.resolveFile(context, MessagingExtension.PAGING_DIRECTORY_PATH);
        File journal = this.resolveFile(context, MessagingExtension.JOURNAL_DIRECTORY_PATH);
        try {
            String uuid;
            TemporaryFileInputStream temp = new TemporaryFileInputStream(Files.createTempFile(this.getServerTempDir(context), "data-print", ".txt", new FileAttribute[0]));
            try (PrintStream out = new PrintStream(temp.getFile().toFile());){
                PrintData.printData((File)bindings, (File)journal, (File)paging, (PrintStream)out, (boolean)secret);
            }
            if (archive) {
                TemporaryFileInputStream tempZip = new TemporaryFileInputStream(Files.createTempFile(this.getServerTempDir(context), "data-print", ".zip", new FileAttribute[0]));
                try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tempZip.getFile(), new OpenOption[0]));){
                    int length;
                    out.putNextEntry(new ZipEntry("data-print-report.txt"));
                    byte[] bytes = new byte[1024];
                    while ((length = temp.read(bytes)) >= 0) {
                        out.write(bytes, 0, length);
                    }
                    out.finish();
                }
                finally {
                    temp.close();
                }
                uuid = context.attachResultStream("application/zip", (InputStream)tempZip);
            } else {
                uuid = context.attachResultStream("text/plain", (InputStream)temp);
            }
            context.getResult().get("uuid").set(uuid);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }
}

