/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.XAJMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContext;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSContext;
import org.apache.activemq.artemis.jms.client.ActiveMQXAJMSContext;
import org.apache.activemq.artemis.jms.client.JmsExceptionUtils;
import org.apache.activemq.artemis.jms.client.ThreadAwareContext;
import org.apache.activemq.artemis.utils.ReferenceCounter;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public abstract class ActiveMQConnectionForContextImpl
implements ActiveMQConnectionForContext {
    final Runnable closeRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                ActiveMQConnectionForContextImpl.this.close();
            }
            catch (JMSException e) {
                throw JmsExceptionUtils.convertToRuntimeException(e);
            }
        }
    };
    final ReferenceCounter refCounter = new ReferenceCounterUtil(this.closeRunnable);
    protected final ThreadAwareContext threadAwareContext = new ThreadAwareContext();

    @Override
    public JMSContext createContext(int sessionMode) {
        switch (sessionMode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 100: 
            case 101: {
                break;
            }
            default: {
                throw new JMSRuntimeException("Invalid ackmode: " + sessionMode);
            }
        }
        this.refCounter.increment();
        return new ActiveMQJMSContext(this, sessionMode, this.threadAwareContext);
    }

    @Override
    public XAJMSContext createXAContext() {
        this.refCounter.increment();
        return new ActiveMQXAJMSContext(this, this.threadAwareContext);
    }

    @Override
    public void closeFromContext() {
        this.refCounter.decrement();
    }

    protected void incrementRefCounter() {
        this.refCounter.increment();
    }

    public ThreadAwareContext getThreadAwareContext() {
        return this.threadAwareContext;
    }
}

