/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.IpAddressUUID;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;
import org.wildfly.clustering.marshalling.spi.Serializer;
import org.wildfly.clustering.marshalling.spi.SerializerExternalizer;

public enum AddressSerializer implements Serializer<Address>
{
    INSTANCE;


    public void write(DataOutput output, Address address) throws IOException {
        Util.writeAddress((Address)address, (DataOutput)output);
    }

    public Address read(DataInput input) throws IOException {
        try {
            return Util.readAddress((DataInput)input);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static class IpAddressUUIDExternalizer
    extends SerializerExternalizer<Address> {
        public IpAddressUUIDExternalizer() {
            super(IpAddressUUID.class, (Serializer)INSTANCE);
        }
    }

    public static class IpAddressExternalizer
    extends SerializerExternalizer<Address> {
        public IpAddressExternalizer() {
            super(IpAddress.class, (Serializer)INSTANCE);
        }
    }

    public static class UUIDExternalizer
    extends SerializerExternalizer<Address> {
        public UUIDExternalizer() {
            super(UUID.class, (Serializer)INSTANCE);
        }
    }
}

