/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSCredential;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SubjectInfo;

final class DelegationSecurityActions {
    DelegationSecurityActions() {
    }

    static GSSCredential getDelegationCredential() {
        return DelegationSecurityActions.delegationCredentialAction().getDelegationCredential();
    }

    private static DelegationCredentialAction delegationCredentialAction() {
        return System.getSecurityManager() != null ? DelegationCredentialAction.PRIVILEGED : DelegationCredentialAction.NON_PRIVILEGED;
    }

    private static interface DelegationCredentialAction {
        public static final DelegationCredentialAction NON_PRIVILEGED = new DelegationCredentialAction(){

            @Override
            public GSSCredential getDelegationCredential() {
                Subject subject;
                SubjectInfo subjectInfo;
                SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
                if (securityContext != null && (subjectInfo = securityContext.getSubjectInfo()) != null && (subject = subjectInfo.getAuthenticatedSubject()) != null) {
                    for (Object current : subject.getPrivateCredentials()) {
                        if (!(current instanceof GSSCredential)) continue;
                        return (GSSCredential)current;
                    }
                }
                return null;
            }
        };
        public static final DelegationCredentialAction PRIVILEGED = new DelegationCredentialAction(){
            final PrivilegedAction<GSSCredential> ACTION = NON_PRIVILEGED::getDelegationCredential;

            @Override
            public GSSCredential getDelegationCredential() {
                return AccessController.doPrivileged(this.ACTION);
            }
        };

        public GSSCredential getDelegationCredential();
    }
}

