/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.CharFormatter;

public class PythonCharFormatter
implements CharFormatter {
    @Override
    public String escapeChar(int c, boolean forCharLiteral) {
        String s = this._escapeChar(c, forCharLiteral);
        return s;
    }

    public String _escapeChar(int c, boolean forCharLiteral) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return forCharLiteral ? "\\'" : "'";
            }
            case 34: {
                return forCharLiteral ? "\"" : "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (0 <= c && c <= 15) {
                return "\\u000" + Integer.toString(c, 16);
            }
            if (16 <= c && c <= 255) {
                return "\\u00" + Integer.toString(c, 16);
            }
            if (256 <= c && c <= 4095) {
                return "\\u0" + Integer.toString(c, 16);
            }
            return "\\u" + Integer.toString(c, 16);
        }
        return String.valueOf((char)c);
    }

    @Override
    public String escapeString(String s) {
        String retval = new String();
        for (int i = 0; i < s.length(); ++i) {
            retval = retval + this.escapeChar(s.charAt(i), false);
        }
        return retval;
    }

    @Override
    public String literalChar(int c) {
        return "" + this.escapeChar(c, true) + "";
    }

    @Override
    public String literalString(String s) {
        return "\"" + this.escapeString(s) + "\"";
    }
}

