/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management;

import java.util.Collections;
import java.util.HashSet;
import org.jboss.migration.wfly10.config.management.ManageableResource;
import org.jboss.migration.wfly10.config.management.ManageableResourceSelector;
import org.jboss.migration.wfly10.config.management.ManageableResourceType;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;

public interface ManageableResourceSelectors {
    public static <T extends ManageableServerConfiguration> ManageableResourceSelector<T> selectServerConfiguration() {
        return resource -> Collections.singleton(resource.getServerConfiguration());
    }

    public static ManageableResourceSelector<ManageableResource> toParent() {
        return resource -> {
            ManageableResource parent = resource.getParentResource();
            return parent != null ? Collections.singleton(parent) : Collections.emptySet();
        };
    }

    public static <T extends ManageableResource> ManageableResourceSelector<T> selectResources(Class<T> resourceType) {
        return resource -> resource.findResources(resourceType);
    }

    public static <T extends ManageableResource> ManageableResourceSelector<T> selectResources(Class<T> resourceType, String resourceName) {
        return resource -> resource.findResources(resourceType, resourceName);
    }

    public static <T extends ManageableResource> ManageableResourceSelector<T> toChildren(Class<T> resourceType) {
        return resource -> new HashSet(resource.getChildResources(resourceType));
    }

    public static <T extends ManageableResource> ManageableResourceSelector<T> toChild(ManageableResourceType resourceType, String resourceName) {
        return resource -> {
            Object child = resource.getChildResource(resourceType, resourceName);
            return child != null ? Collections.singleton(child) : Collections.emptySet();
        };
    }
}

