/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class AuthorizationConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((String)"enabled", (Object)false).immutable().build();
    public static final AttributeDefinition<Set> ROLES = AttributeDefinition.builder((String)"roles", null, Set.class).initializer(HashSet::new).build();
    static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.AUTHORIZATION.getLocalName());
    private final Attribute<Boolean> enabled;
    private final Attribute<Set> roles;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthorizationConfiguration.class, new AttributeDefinition[]{ENABLED, ROLES});
    }

    AuthorizationConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.enabled = attributes.attribute(ENABLED);
        this.roles = attributes.attribute(ROLES);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public Set<String> roles() {
        return (Set)this.roles.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "AuthorizationConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationConfiguration other = (AuthorizationConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }
}

