/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.util.AttachmentKey;
import org.jboss.as.web.session.SessionIdentifierCodec;

public class CodecSessionConfig
implements SessionConfig {
    private static final AttachmentKey<Boolean> SESSION_ID_SET = AttachmentKey.create(Boolean.class);
    private final SessionConfig config;
    private final SessionIdentifierCodec codec;

    public CodecSessionConfig(SessionConfig config, SessionIdentifierCodec codec) {
        this.config = config;
        this.codec = codec;
    }

    public void setSessionId(HttpServerExchange exchange, String sessionId) {
        exchange.putAttachment(SESSION_ID_SET, (Object)Boolean.TRUE);
        this.config.setSessionId(exchange, this.codec.encode((CharSequence)sessionId).toString());
    }

    public void clearSession(HttpServerExchange exchange, String sessionId) {
        this.config.clearSession(exchange, this.codec.encode((CharSequence)sessionId).toString());
    }

    public String findSessionId(HttpServerExchange exchange) {
        String encodedSessionId = this.config.findSessionId(exchange);
        if (encodedSessionId == null) {
            return null;
        }
        CharSequence sessionId = this.codec.decode((CharSequence)encodedSessionId);
        CharSequence reencodedSessionId = this.codec.encode(sessionId);
        if (exchange.getAttachment(SESSION_ID_SET) == null && !encodedSessionId.contentEquals(reencodedSessionId)) {
            this.config.setSessionId(exchange, reencodedSessionId.toString());
        }
        return sessionId.toString();
    }

    public SessionConfig.SessionCookieSource sessionCookieSource(HttpServerExchange exchange) {
        return this.config.sessionCookieSource(exchange);
    }

    public String rewriteUrl(String originalUrl, String sessionId) {
        return this.config.rewriteUrl(originalUrl, this.codec.encode((CharSequence)sessionId).toString());
    }
}

