/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.journal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.core.journal.impl.JournalCompactor;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalRecord;
import org.apache.activemq.artemis.core.journal.impl.JournalRecordProvider;
import org.apache.activemq.artemis.core.journal.impl.TransactionCallback;
import org.apache.activemq.artemis.core.journal.impl.dataformat.JournalInternalRecord;
import org.jboss.logging.Logger;

public class JournalTransaction {
    private static final Logger logger = Logger.getLogger(JournalTransaction.class);
    private JournalRecordProvider journal;
    private List<JournalUpdate> pos;
    private List<JournalUpdate> neg;
    private final long id;
    private Set<JournalFile> pendingFiles;
    private TransactionCallback currentCallback;
    private boolean compacting = false;
    private final Map<JournalFile, TransactionCallback> callbackList = Collections.synchronizedMap(new HashMap());
    private JournalFile lastFile = null;
    private final AtomicInteger counter = new AtomicInteger();
    private CountDownLatch firstCallbackLatch;

    public JournalTransaction(long id, JournalRecordProvider journal) {
        this.id = id;
        this.journal = journal;
    }

    public void replaceRecordProvider(JournalRecordProvider provider) {
        this.journal = provider;
    }

    public long getId() {
        return this.id;
    }

    public int getCounter(JournalFile file) {
        return this.internalgetCounter(file).intValue();
    }

    public void incCounter(JournalFile file) {
        this.internalgetCounter(file).incrementAndGet();
    }

    public long[] getPositiveArray() {
        if (this.pos == null) {
            return new long[0];
        }
        int i = 0;
        long[] ids = new long[this.pos.size()];
        for (JournalUpdate el : this.pos) {
            ids[i++] = el.getId();
        }
        return ids;
    }

    public void setCompacting() {
        this.compacting = true;
        this.clear();
    }

    public void merge(JournalTransaction other) {
        if (other.pos != null) {
            if (this.pos == null) {
                this.pos = new ArrayList<JournalUpdate>();
            }
            this.pos.addAll(other.pos);
        }
        if (other.neg != null) {
            if (this.neg == null) {
                this.neg = new ArrayList<JournalUpdate>();
            }
            this.neg.addAll(other.neg);
        }
        if (other.pendingFiles != null) {
            if (this.pendingFiles == null) {
                this.pendingFiles = new HashSet<JournalFile>();
            }
            this.pendingFiles.addAll(other.pendingFiles);
        }
        this.compacting = false;
    }

    public void clear() {
        if (this.pendingFiles != null) {
            this.pendingFiles.clear();
        }
        this.callbackList.clear();
        if (this.pos != null) {
            this.pos.clear();
        }
        if (this.neg != null) {
            this.neg.clear();
        }
        this.counter.set(0);
        this.lastFile = null;
        this.currentCallback = null;
        this.firstCallbackLatch = null;
    }

    public void fillNumberOfRecords(JournalFile currentFile, JournalInternalRecord data) {
        data.setNumberOfRecords(this.getCounter(currentFile));
    }

    public TransactionCallback getCurrentCallback() {
        return this.currentCallback;
    }

    public TransactionCallback getCallback(JournalFile file) throws Exception {
        if (this.firstCallbackLatch != null && this.callbackList.isEmpty()) {
            this.firstCallbackLatch.countDown();
        }
        this.currentCallback = this.callbackList.get(file);
        if (this.currentCallback == null) {
            this.currentCallback = new TransactionCallback();
            this.callbackList.put(file, this.currentCallback);
        }
        this.currentCallback.countUp();
        return this.currentCallback;
    }

    public void checkErrorCondition() throws Exception {
        if (this.currentCallback != null && this.currentCallback.getErrorMessage() != null) {
            throw ActiveMQExceptionType.createException((int)this.currentCallback.getErrorCode(), (String)this.currentCallback.getErrorMessage());
        }
    }

    public void addPositive(JournalFile file, long id, int size, byte userRecordType) {
        this.incCounter(file);
        this.addFile(file);
        if (this.pos == null) {
            this.pos = new ArrayList<JournalUpdate>();
        }
        this.pos.add(new JournalUpdate(file, id, size, userRecordType));
    }

    public void addNegative(JournalFile file, long id) {
        this.incCounter(file);
        this.addFile(file);
        if (this.neg == null) {
            this.neg = new ArrayList<JournalUpdate>();
        }
        this.neg.add(new JournalUpdate(file, id, 0, 0));
    }

    public void commit(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting && compactor != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("adding txID=" + this.id + " into compacting"));
            }
            compactor.addCommandCommit(this, file);
        } else {
            JournalRecord posFiles;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("there was no compactor on commit txID=" + this.id));
            }
            if (this.pos != null) {
                for (JournalUpdate trUpdate : this.pos) {
                    posFiles = (JournalRecord)this.journal.getRecords().get(trUpdate.id);
                    if (compactor != null && compactor.containsRecord(trUpdate.id)) {
                        compactor.addCommandUpdate(trUpdate.id, trUpdate.file, trUpdate.size, trUpdate.userRecordType);
                        continue;
                    }
                    if (posFiles == null) {
                        posFiles = new JournalRecord(trUpdate.file, trUpdate.size);
                        this.journal.getRecords().put(trUpdate.id, (Object)posFiles);
                        continue;
                    }
                    posFiles.addUpdateFile(trUpdate.file, trUpdate.size, this.journal.isReplaceableRecord(trUpdate.userRecordType));
                }
            }
            if (this.neg != null) {
                for (JournalUpdate trDelete : this.neg) {
                    if (compactor != null) {
                        compactor.addCommandDelete(trDelete.id, trDelete.file);
                        continue;
                    }
                    posFiles = (JournalRecord)this.journal.getRecords().remove(trDelete.id);
                    if (posFiles == null) continue;
                    posFiles.delete(trDelete.file);
                }
            }
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitCallbacks() throws InterruptedException {
        this.waitFirstCallback();
        Map<JournalFile, TransactionCallback> map = this.callbackList;
        synchronized (map) {
            for (TransactionCallback callback : this.callbackList.values()) {
                callback.waitCompletion();
            }
        }
    }

    public void waitCompletion() throws Exception {
        this.waitFirstCallback();
        this.currentCallback.waitCompletion();
    }

    private void waitFirstCallback() throws InterruptedException {
        if (this.currentCallback == null) {
            this.firstCallbackLatch = new CountDownLatch(1);
            this.firstCallbackLatch.await();
            this.firstCallbackLatch = null;
        }
    }

    public void rollback(JournalFile file) {
        JournalCompactor compactor = this.journal.getCompactor();
        if (this.compacting && compactor != null) {
            compactor.addCommandRollback(this, file);
        } else {
            for (JournalFile jf : this.pendingFiles) {
                file.incNegCount(jf);
            }
        }
    }

    public void prepare(JournalFile file) {
        this.addFile(file);
    }

    public void forget() {
        for (JournalFile jf : this.pendingFiles) {
            jf.decPosCount();
        }
    }

    public String toString() {
        return "JournalTransaction(" + this.id + ")";
    }

    private AtomicInteger internalgetCounter(JournalFile file) {
        if (this.lastFile != file) {
            this.lastFile = file;
            this.counter.set(0);
        }
        return this.counter;
    }

    private void addFile(JournalFile file) {
        if (this.pendingFiles == null) {
            this.pendingFiles = new HashSet<JournalFile>();
        }
        if (!this.pendingFiles.contains(file)) {
            this.pendingFiles.add(file);
            file.incPosCount();
        }
    }

    private static class JournalUpdate {
        private final JournalFile file;
        long id;
        int size;
        final byte userRecordType;

        private JournalUpdate(JournalFile file, long id, int size, byte userRecordType) {
            this.file = file;
            this.id = id;
            this.size = size;
            this.userRecordType = userRecordType;
        }

        public long getId() {
            return this.id;
        }
    }
}

