/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.transaction.lookup;

import java.util.Optional;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import net.jcip.annotations.GuardedBy;
import org.infinispan.client.hotrod.transaction.manager.RemoteTransactionManager;
import org.infinispan.commons.tx.lookup.LookupNames;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;

public class GenericTransactionManagerLookup
implements TransactionManagerLookup {
    private static final GenericTransactionManagerLookup INSTANCE = new GenericTransactionManagerLookup();
    @GuardedBy(value="this")
    private TransactionManager transactionManager = null;

    private GenericTransactionManagerLookup() {
    }

    public static GenericTransactionManagerLookup getInstance() {
        return INSTANCE;
    }

    public synchronized TransactionManager getTransactionManager() {
        if (this.transactionManager != null) {
            return this.transactionManager;
        }
        this.transactionManager = this.tryTmFactoryLookup().orElseGet(RemoteTransactionManager::getInstance);
        this.transactionManager = this.tryJndiLookup().orElseGet(() -> this.tryTmFactoryLookup().orElseGet(RemoteTransactionManager::getInstance));
        return this.transactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<TransactionManager> tryJndiLookup() {
        InitialContext ctx;
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            return Optional.empty();
        }
        try {
            for (LookupNames.JndiTransactionManager knownJNDIManager : LookupNames.JndiTransactionManager.values()) {
                Object jndiObject;
                try {
                    jndiObject = ctx.lookup(knownJNDIManager.getJndiLookup());
                }
                catch (NamingException e) {
                    continue;
                }
                if (!(jndiObject instanceof TransactionManager)) continue;
                Optional<TransactionManager> optional = Optional.of((TransactionManager)jndiObject);
                return optional;
            }
        }
        finally {
            Util.close((Context)ctx);
        }
        return Optional.empty();
    }

    private Optional<TransactionManager> tryTmFactoryLookup() {
        for (LookupNames.TransactionManagerFactory transactionManagerFactory : LookupNames.TransactionManagerFactory.values()) {
            TransactionManager transactionManager = transactionManagerFactory.tryLookup(GenericTransactionManagerLookup.class.getClassLoader());
            if (transactionManager == null) continue;
            return Optional.of(transactionManager);
        }
        return Optional.empty();
    }
}

