/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;

public class ProcessingQueue<T> {
    protected final Queue<T> queue = new ConcurrentLinkedQueue<T>();
    protected final ReentrantLock producer_lock = new ReentrantLock();
    protected final ReentrantLock consumer_lock = new ReentrantLock();
    protected int count = 0;
    protected Handler<T> handler;

    public Queue<T> getQueue() {
        return this.queue;
    }

    public int size() {
        return this.queue.size();
    }

    public ProcessingQueue<T> setHandler(Handler<T> handler) {
        this.handler = handler;
        return this;
    }

    public void add(T element) {
        this.producer_lock.lock();
        try {
            this.queue.add(element);
            ++this.count;
        }
        finally {
            this.producer_lock.unlock();
        }
        this.process();
    }

    public boolean retainAll(Collection<T> elements) {
        return this.queue.retainAll(elements);
    }

    public String toString() {
        return this.queue.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected void process() {
        block14: {
            if (!this.consumer_lock.tryLock()) break block14;
            while (true) lbl-1000:
            // 3 sources

            {
                if ((element = this.queue.poll()) != null && this.handler != null) {
                    try {
                        this.handler.handle(element);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
                this.producer_lock.lock();
                try {
                    if (this.count == 0 || this.count - 1 == 0) {
                        this.count = 0;
                        this.consumer_lock.unlock();
                        return;
                    }
                    --this.count;
                }
                finally {
                    this.producer_lock.unlock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                if (this.consumer_lock.isHeldByCurrentThread()) {
                    this.consumer_lock.unlock();
                }
            }
        }
    }

    public static interface Handler<T> {
        public void handle(T var1);
    }
}

