/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.HashSet;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageDataIndex;
import org.h2.index.PageIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.RegularTable;
import org.h2.table.TableFilter;

public class PageDelegateIndex
extends PageIndex {
    private final PageDataIndex mainIndex;

    public PageDelegateIndex(RegularTable table, int id, String name, IndexType indexType, PageDataIndex mainIndex, boolean create, Session session) {
        IndexColumn[] cols = IndexColumn.wrap(new Column[]{table.getColumn(mainIndex.getMainIndexColumn())});
        this.initBaseIndex(table, id, name, cols, indexType);
        this.mainIndex = mainIndex;
        if (!this.database.isPersistent() || id < 0) {
            throw DbException.throwInternalError("" + name);
        }
        PageStore store = this.database.getPageStore();
        store.addIndex(this);
        if (create) {
            store.addMeta(this, session);
        }
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        long min = this.mainIndex.getKey(first, Long.MIN_VALUE, Long.MIN_VALUE);
        long max = this.mainIndex.getKey(last, Long.MAX_VALUE, Long.MIN_VALUE);
        return this.mainIndex.find(session, min, max, false);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        Cursor cursor;
        if (first) {
            cursor = this.mainIndex.find(session, Long.MIN_VALUE, Long.MAX_VALUE, false);
        } else {
            long x = this.mainIndex.getLastKey();
            cursor = this.mainIndex.find(session, x, x, false);
        }
        cursor.next();
        return cursor;
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        throw DbException.throwInternalError();
    }

    @Override
    public int getColumnIndex(Column col) {
        if (col.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return 10L * this.getCostRangeIndex(masks, this.mainIndex.getRowCount(session), filters, filter, sortOrder, false, allColumnsSet);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
        session.getDatabase().getPageStore().removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.mainIndex.getDiskSpaceUsed();
    }

    @Override
    public void writeRowCount() {
    }
}

