/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

public class JdbcSQLException
extends SQLException {
    public static final String HIDE_SQL = "--hide--";
    private static final long serialVersionUID = 1L;
    private final String originalMessage;
    private final Throwable cause;
    private final String stackTrace;
    private String message;
    private String sql;

    public JdbcSQLException(String message, String sql, String state, int errorCode, Throwable cause, String stackTrace) {
        super(message, state, errorCode);
        this.originalMessage = message;
        this.setSQL(sql);
        this.cause = cause;
        this.stackTrace = stackTrace;
        this.buildMessage();
        this.initCause(cause);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (s != null) {
            super.printStackTrace(s);
            SQLException next = this.getNextException();
            for (int i = 0; i < 100 && next != null; next = next.getNextException(), ++i) {
                s.println(next.toString());
            }
            if (next != null) {
                s.println("(truncated)");
            }
        }
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (s != null) {
            super.printStackTrace(s);
            SQLException next = this.getNextException();
            for (int i = 0; i < 100 && next != null; next = next.getNextException(), ++i) {
                s.println(next.toString());
            }
            if (next != null) {
                s.println("(truncated)");
            }
        }
    }

    public Throwable getOriginalCause() {
        return this.cause;
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql) {
        if (sql != null && sql.contains(HIDE_SQL)) {
            sql = "-";
        }
        this.sql = sql;
        this.buildMessage();
    }

    private void buildMessage() {
        StringBuilder buff = new StringBuilder(this.originalMessage == null ? "- " : this.originalMessage);
        if (this.sql != null) {
            buff.append("; SQL statement:\n").append(this.sql);
        }
        buff.append(" [").append(this.getErrorCode()).append('-').append(193).append(']');
        this.message = buff.toString();
    }

    @Override
    public String toString() {
        if (this.stackTrace == null) {
            return super.toString();
        }
        return this.stackTrace;
    }
}

