/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.h2.api.TimestampWithTimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;

public class LocalDateTimeUtils {
    private static Class<?> LOCAL_DATE;
    private static Class<?> LOCAL_TIME;
    private static Class<?> LOCAL_DATE_TIME;
    private static Class<?> OFFSET_DATE_TIME;
    private static Class<?> ZONE_OFFSET;
    private static Method TO_LOCAL_DATE;
    private static Method TO_LOCAL_TIME;
    private static Method DATE_VALUE_OF;
    private static Method TIME_VALUE_OF;
    private static Method LOCAL_DATE_OF_YEAR_MONTH_DAY;
    private static Method LOCAL_DATE_PARSE;
    private static Method LOCAL_DATE_GET_YEAR;
    private static Method LOCAL_DATE_GET_MONTH_VALUE;
    private static Method LOCAL_DATE_GET_DAY_OF_MONTH;
    private static Method LOCAL_DATE_AT_START_OF_DAY;
    private static Method LOCAL_TIME_PARSE;
    private static Method LOCAL_DATE_TIME_PLUS_NANOS;
    private static Method LOCAL_DATE_TIME_TO_LOCAL_DATE;
    private static Method LOCAL_DATE_TIME_TRUNCATED_TO;
    private static Method LOCAL_DATE_TIME_PARSE;
    private static Method ZONE_OFFSET_OF_TOTAL_SECONDS;
    private static Method OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET;
    private static Method OFFSET_DATE_TIME_PARSE;
    private static Method OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME;
    private static Method OFFSET_DATE_TIME_GET_OFFSET;
    private static Method ZONE_OFFSET_GET_TOTAL_SECONDS;
    private static Method DURATION_BETWEEN;
    private static Method DURATION_TO_NANOS;
    private static Object CHRONO_UNIT_DAYS;
    private static final boolean IS_JAVA8_DATE_API_PRESENT;

    private LocalDateTimeUtils() {
    }

    public static boolean isJava8DateApiPresent() {
        return IS_JAVA8_DATE_API_PRESENT;
    }

    public static Class<?> getLocalDateClass() {
        return LOCAL_DATE;
    }

    public static Class<?> getLocalTimeClass() {
        return LOCAL_TIME;
    }

    public static Class<?> getLocalDateTimeClass() {
        return LOCAL_DATE_TIME;
    }

    public static Class<?> getOffsetDateTimeClass() {
        return OFFSET_DATE_TIME;
    }

    public static Object parseLocalDate(CharSequence text) {
        try {
            return LOCAL_DATE_PARSE.invoke(null, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("error when parsing text '" + text + "'", e);
        }
    }

    public static Object parseLocalTime(CharSequence text) {
        try {
            return LOCAL_TIME_PARSE.invoke(null, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("error when parsing text '" + text + "'", e);
        }
    }

    public static Object parseLocalDateTime(CharSequence text) {
        try {
            return LOCAL_DATE_TIME_PARSE.invoke(null, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("error when parsing text '" + text + "'", e);
        }
    }

    public static Object parseOffsetDateTime(CharSequence text) {
        try {
            return OFFSET_DATE_TIME_PARSE.invoke(null, text);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("error when parsing text '" + text + "'", e);
        }
    }

    private static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Java 8 or later but class " + className + " is missing", e);
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Java 8 or later but method " + clazz.getName() + "#" + methodName + "(" + Arrays.toString(parameterTypes) + ") is missing", e);
        }
    }

    private static Object getFieldValue(Class<?> clazz, String fieldName) {
        try {
            return clazz.getField(fieldName).get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException("Java 8 or later but field " + clazz.getName() + "#" + fieldName + " is missing", e);
        }
    }

    public static boolean isLocalDate(Class<?> clazz) {
        return LOCAL_DATE == clazz;
    }

    public static boolean isLocalTime(Class<?> clazz) {
        return LOCAL_TIME == clazz;
    }

    public static boolean isLocalDateTime(Class<?> clazz) {
        return LOCAL_DATE_TIME == clazz;
    }

    public static boolean isOffsetDateTime(Class<?> clazz) {
        return OFFSET_DATE_TIME == clazz;
    }

    public static Object valueToLocalDate(Value value) {
        return LocalDateTimeUtils.dateToLocalDate(value.getDate());
    }

    public static Object valueToLocalTime(Value value) {
        return LocalDateTimeUtils.timeToLocalTime(value.getTime());
    }

    private static Object dateToLocalDate(Date date) {
        try {
            return TO_LOCAL_DATE.invoke((Object)date, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "date conversion failed");
        }
    }

    private static Object timeToLocalTime(Time time) {
        try {
            return TO_LOCAL_TIME.invoke((Object)time, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    public static Object valueToLocalDateTime(ValueTimestamp value) {
        long dateValue = value.getDateValue();
        long timeNanos = value.getTimeNanos();
        try {
            Object localDate = LocalDateTimeUtils.localDateFromDateValue(dateValue);
            Object localDateTime = LOCAL_DATE_AT_START_OF_DAY.invoke(localDate, new Object[0]);
            return LOCAL_DATE_TIME_PLUS_NANOS.invoke(localDateTime, timeNanos);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp conversion failed");
        }
    }

    public static Object valueToOffsetDateTime(ValueTimestampTimeZone value) {
        return LocalDateTimeUtils.timestampWithTimeZoneToOffsetDateTime((TimestampWithTimeZone)value.getObject());
    }

    private static Object timestampWithTimeZoneToOffsetDateTime(TimestampWithTimeZone timestampWithTimeZone) {
        long dateValue = timestampWithTimeZone.getYMD();
        long timeNanos = timestampWithTimeZone.getNanosSinceMidnight();
        try {
            Object localDateTime = LocalDateTimeUtils.localDateTimeFromDateNanos(dateValue, timeNanos);
            short timeZoneOffsetMins = timestampWithTimeZone.getTimeZoneOffsetMins();
            int offsetSeconds = (int)TimeUnit.MINUTES.toSeconds(timeZoneOffsetMins);
            Object offset = ZONE_OFFSET_OF_TOTAL_SECONDS.invoke(null, offsetSeconds);
            return OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET.invoke(null, localDateTime, offset);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "timestamp with time zone conversion failed");
        }
    }

    public static Value localDateToDateValue(Object localDate) {
        try {
            Date date = (Date)DATE_VALUE_OF.invoke(null, localDate);
            return ValueDate.get(date);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "date conversion failed");
        }
    }

    public static Value localTimeToTimeValue(Object localTime) {
        try {
            Time time = (Time)TIME_VALUE_OF.invoke(null, localTime);
            return ValueTime.get(time);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    public static Value localDateTimeToValue(Object localDateTime) {
        try {
            Object localDate = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(localDateTime, new Object[0]);
            long dateValue = LocalDateTimeUtils.dateValueFromLocalDate(localDate);
            long timeNanos = LocalDateTimeUtils.timeNanosFromLocalDate(localDateTime);
            return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "local date time conversion failed");
        }
    }

    public static Value offsetDateTimeToValue(Object offsetDateTime) {
        try {
            Object localDateTime = OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME.invoke(offsetDateTime, new Object[0]);
            Object localDate = LOCAL_DATE_TIME_TO_LOCAL_DATE.invoke(localDateTime, new Object[0]);
            Object zoneOffset = OFFSET_DATE_TIME_GET_OFFSET.invoke(offsetDateTime, new Object[0]);
            long dateValue = LocalDateTimeUtils.dateValueFromLocalDate(localDate);
            long timeNanos = LocalDateTimeUtils.timeNanosFromLocalDate(localDateTime);
            short timeZoneOffsetMins = LocalDateTimeUtils.zoneOffsetToOffsetMinute(zoneOffset);
            return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, timeNanos, timeZoneOffsetMins);
        }
        catch (IllegalAccessException e) {
            throw DbException.convert(e);
        }
        catch (InvocationTargetException e) {
            throw DbException.convertInvocation(e, "time conversion failed");
        }
    }

    private static long dateValueFromLocalDate(Object localDate) throws IllegalAccessException, InvocationTargetException {
        int year = (Integer)LOCAL_DATE_GET_YEAR.invoke(localDate, new Object[0]);
        int month = (Integer)LOCAL_DATE_GET_MONTH_VALUE.invoke(localDate, new Object[0]);
        int day = (Integer)LOCAL_DATE_GET_DAY_OF_MONTH.invoke(localDate, new Object[0]);
        return DateTimeUtils.dateValue(year, month, day);
    }

    private static long timeNanosFromLocalDate(Object localDateTime) throws IllegalAccessException, InvocationTargetException {
        Object midnight = LOCAL_DATE_TIME_TRUNCATED_TO.invoke(localDateTime, CHRONO_UNIT_DAYS);
        Object duration = DURATION_BETWEEN.invoke(null, midnight, localDateTime);
        return (Long)DURATION_TO_NANOS.invoke(duration, new Object[0]);
    }

    private static short zoneOffsetToOffsetMinute(Object zoneOffset) throws IllegalAccessException, InvocationTargetException {
        int totalSeconds = (Integer)ZONE_OFFSET_GET_TOTAL_SECONDS.invoke(zoneOffset, new Object[0]);
        return (short)TimeUnit.SECONDS.toMinutes(totalSeconds);
    }

    private static Object localDateFromDateValue(long dateValue) throws IllegalAccessException, InvocationTargetException {
        int year = DateTimeUtils.yearFromDateValue(dateValue);
        int month = DateTimeUtils.monthFromDateValue(dateValue);
        int day = DateTimeUtils.dayFromDateValue(dateValue);
        return LOCAL_DATE_OF_YEAR_MONTH_DAY.invoke(null, year, month, day);
    }

    private static Object localDateTimeFromDateNanos(long dateValue, long timeNanos) throws IllegalAccessException, InvocationTargetException {
        Object localDate = LocalDateTimeUtils.localDateFromDateValue(dateValue);
        Object localDateTime = LOCAL_DATE_AT_START_OF_DAY.invoke(localDate, new Object[0]);
        return LOCAL_DATE_TIME_PLUS_NANOS.invoke(localDateTime, timeNanos);
    }

    static {
        boolean isJava8DateApiPresent;
        try {
            LOCAL_DATE = Class.forName("java.time.LocalDate");
            LOCAL_TIME = Class.forName("java.time.LocalTime");
            LOCAL_DATE_TIME = Class.forName("java.time.LocalDateTime");
            OFFSET_DATE_TIME = Class.forName("java.time.OffsetDateTime");
            ZONE_OFFSET = Class.forName("java.time.ZoneOffset");
            isJava8DateApiPresent = true;
        }
        catch (ClassNotFoundException e) {
            isJava8DateApiPresent = false;
        }
        IS_JAVA8_DATE_API_PRESENT = isJava8DateApiPresent;
        if (IS_JAVA8_DATE_API_PRESENT) {
            Class<?> temporalUnit = LocalDateTimeUtils.getClass("java.time.temporal.TemporalUnit");
            Class<?> chronoUnit = LocalDateTimeUtils.getClass("java.time.temporal.ChronoUnit");
            Class<?> duration = LocalDateTimeUtils.getClass("java.time.Duration");
            Class<?> temporal = LocalDateTimeUtils.getClass("java.time.temporal.Temporal");
            TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(Date.class, "toLocalDate", new Class[0]);
            TO_LOCAL_TIME = LocalDateTimeUtils.getMethod(Time.class, "toLocalTime", new Class[0]);
            DATE_VALUE_OF = LocalDateTimeUtils.getMethod(Date.class, "valueOf", LOCAL_DATE);
            TIME_VALUE_OF = LocalDateTimeUtils.getMethod(Time.class, "valueOf", LOCAL_TIME);
            LOCAL_DATE_OF_YEAR_MONTH_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "of", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            LOCAL_DATE_PARSE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "parse", CharSequence.class);
            LOCAL_DATE_GET_YEAR = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getYear", new Class[0]);
            LOCAL_DATE_GET_MONTH_VALUE = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getMonthValue", new Class[0]);
            LOCAL_DATE_GET_DAY_OF_MONTH = LocalDateTimeUtils.getMethod(LOCAL_DATE, "getDayOfMonth", new Class[0]);
            LOCAL_DATE_AT_START_OF_DAY = LocalDateTimeUtils.getMethod(LOCAL_DATE, "atStartOfDay", new Class[0]);
            LOCAL_TIME_PARSE = LocalDateTimeUtils.getMethod(LOCAL_TIME, "parse", CharSequence.class);
            LOCAL_DATE_TIME_PLUS_NANOS = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "plusNanos", Long.TYPE);
            LOCAL_DATE_TIME_TO_LOCAL_DATE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "toLocalDate", new Class[0]);
            LOCAL_DATE_TIME_TRUNCATED_TO = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "truncatedTo", temporalUnit);
            LOCAL_DATE_TIME_PARSE = LocalDateTimeUtils.getMethod(LOCAL_DATE_TIME, "parse", CharSequence.class);
            ZONE_OFFSET_OF_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "ofTotalSeconds", Integer.TYPE);
            OFFSET_DATE_TIME_TO_LOCAL_DATE_TIME = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "toLocalDateTime", new Class[0]);
            OFFSET_DATE_TIME_GET_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "getOffset", new Class[0]);
            OFFSET_DATE_TIME_OF_LOCAL_DATE_TIME_ZONE_OFFSET = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "of", LOCAL_DATE_TIME, ZONE_OFFSET);
            OFFSET_DATE_TIME_PARSE = LocalDateTimeUtils.getMethod(OFFSET_DATE_TIME, "parse", CharSequence.class);
            ZONE_OFFSET_GET_TOTAL_SECONDS = LocalDateTimeUtils.getMethod(ZONE_OFFSET, "getTotalSeconds", new Class[0]);
            DURATION_BETWEEN = LocalDateTimeUtils.getMethod(duration, "between", temporal, temporal);
            DURATION_TO_NANOS = LocalDateTimeUtils.getMethod(duration, "toNanos", new Class[0]);
            CHRONO_UNIT_DAYS = LocalDateTimeUtils.getFieldValue(chronoUnit, "DAYS");
        }
    }
}

